%
% This script plots A plot of thermal conductivity versus
% water content for three soil types.
%
thetas=0.0:0.01:0.5;
for i=1:51, lambdas(i)=lambda(thetas(i),0.2,0.4,0.03); end;
for i=1:51, lambdas2(i)=lambda(thetas(i),0.5,0.0,0.32); end;
for i=1:51, lambdas3(i)=lambda(thetas(i),0.5,0.0,0.72); end;
plot(thetas*100,lambdas,'k');
hold on;
plot(thetas*100,lambdas2,'k');
plot(thetas*100,lambdas3,'k');
xlabel('\theta_{v} (%)');
ylabel('\lambda (W/(mK))');
text(10,2.0,'Sand');
text(20,1.0,'Silt');  
text(25,0.75,'Clay');   

