%
% This script plots the heat capacity vs. water content for thee soil
% types.
%
thetas=0.0:0.01:0.5;
for i=1:51, thetag(i)=thetas(i)/1.6; end;
for i=1:51, h(i)=heatcap(1.6,0.73,4.18,thetag(i)); end;
for i=1:51, thetag(i)=thetas(i)/1.3; end;
for i=1:51, h2(i)=heatcap(1.3,0.73,4.18,thetag(i)); end;
for i=1:51, thetag(i)=thetas(i)/1.5; end;
for i=1:51, h3(i)=heatcap(1.5,0.73,4.18,thetag(i)); end;

plot(thetas*100,h,'k');
hold on;
plot(thetas*100,h2,'k');
plot(thetas*100,h3,'k');
xlabel('\theta_{v} (%)');
ylabel('c (kJ/(kg K))');
text(3,1.5,'Sand');
text(10,1.5,'Silt');
text(5,1.1,'Clay');

