%
% c=heatcap(rhob,cs,cw,thetag)
%
% Compute the volumetric heat capacity of a soil.  This is just given
% by a simple mixing formula, using the presumed known volumetric 
% heat capacity of the water and the soil particles.  The air in pore
% spaces is simply ignored here.
%
%    cs           Specific heat of the soil particles.  A typical value
%                 would be 0.73 kJ/(kg K)
%    cw           Specific heat of the water.  4.18 kJ/(kg K)
%    thetag       Gravimetric water content.  
%    rhob         Bulk density of the soil (g/cm^3)
%
% Note that gravimetric water content is not the same as volumetric.  However,
% we can convert using
%
%   thetag=(rhow*thetav)/rhob
%
% where rhow is the density of water (1g/cm^3), thetav is the volumetric
% water content, and rhob is the bulk density of the soil.
%
function c=heatcap(rhob,cs,cw,thetag)
c=rhob*(cs+cw*thetag);
