#include "graphtools.h"


/* 
 * globals for the bpm problem
 */

int BESTVAL;
int CURRENTLEVEL;
int *nodemap;			/* from node number to reduced node number in subgraph */
double *xvalues;
int *reducednodenumbers;
struct blockmatrix work;
double *workvec;

/*
* Storage for a heuristic solution
*/

int *HEUR_solution;


void initializeGraphTools(nodes, edges)
	int nodes;
	int edges;
{
	int i,j;

	/*
	 * alloctaion of space for the theta problem
	 */
	
  xvalues=(double *)malloc((nodes+1)*sizeof(double));
  reducednodenumbers=(int *)malloc((nodes+1)*sizeof(int));

  /*
   * Allocate work space for the user exit routines.
   */

  workvec=(double *)malloc((nodes+2*edges+1)*sizeof(double));
  work.nblocks=1;
  work.blocks=malloc(2*sizeof(struct blockrec));
  work.blocks[1].blockcategory=MATRIX;
  work.blocks[1].blocksize=nodes;
  work.blocks[1].data.mat=(double *)
    malloc(nodes*nodes*sizeof(double));
  for (j=1; j<=nodes; j++)
    for (i=1; i<=nodes; i++)
      {
	work.blocks[1].data.mat[ijtok(i,j,nodes)]=0.0;
      };

  nodemap=(int *)malloc((nodes+1)*sizeof(int));
  if (nodemap==NULL)
    {
      printf("Storage allocation failed.\n");
      exit(1);
    };
	
	/*
	 * allocate space for the heuristic solution
	 */
	 
	HEUR_solution=(int *)malloc((nodes+1)*sizeof(int));
	if (HEUR_solution==NULL)
	{
		printf("Storage allocation failed!\n");
		exit(1);
	};
	
	for (i=1; i<=nodes; i++)
		HEUR_solution[i]=-1;

}

void destroyGraphTools() 
{

	free(work.blocks[1].data.mat);
	free(workvec);
	free(reducednodenumbers);
	free(xvalues);

/*	free(BPM_Z);
	free(BPM_W);
	free(BPM_y);
	free(BPM_Aty);
	free(BPM_X);
	free(BPM_work);*/

}

void cliqueSearch(currentnode, table, vertices, neighbors, deg)
	struct noderec *currentnode;
	char *table;
	int vertices;
	int **neighbors;
	int *deg;
{	
	int i,j,k,kk,count;
	int cliqueok;
	int foundclique = 1;
	
	while (foundclique==1)
	{
		foundclique=0;
		
		for (i=1; i<=vertices; i++)
		{
			if (currentnode->vals[i]==-1)
			{
				/* 
				* Check to see whether the neighbors of this node form a clique.
				*/
				
				cliqueok=1;
				for (k=1; k<=deg[i]-1; k++)
				{
					j=neighbors[i][k];
					
					if (currentnode->vals[j]==-1)
					{
						for (kk=k+1; kk<=deg[i]; kk++)
						{
							if ((table[ijtok(j,(neighbors[i][kk]),vertices)] != 'x') &&
								(currentnode->vals[neighbors[i][kk]]==-1))
							{
								cliqueok=0;
								break;
							}
						};
						
						if (cliqueok==0)
							break;
					};
				};
				
				if (cliqueok==1)
				{
					/*
					 * found a clique, set one node to 1, the others to 0 
					 */
					currentnode->vals[i]=1;
					count=0;
					
					for (k=1; k<=deg[i]; k++)
					{
						if (currentnode->vals[neighbors[i][k]]==-1)
						{
							count++;
							currentnode->boundest=currentnode->boundest-0.05;
							currentnode->vals[neighbors[i][k]]=0;
						};
					};

#ifdef VERBOSE
					printf("Found a node-and-clique, node=%d, size=%d\n",i,count);
					fflush(stdout);
#endif

					/*
					 * We've changed the unset subgraph, search for cliques again
					 */
					 
					foundclique=1;
				};
			}; 
		};
	};
}

void createNeighbors(table, vertices, neighbors, deg)
	char *table;
	int vertices;
	int **neighbors;
	int *deg;
{
	int i,j,count;
	
	for (j=1; j<=vertices; j++)
	{
		deg[j]=0;
		for (i=1; i<=vertices; i++)
		{
			if (table[ijtok(i,j,vertices)]=='x')
			deg[j]=deg[j]+1;
		};
	};
	
	/*
	 * Make up neighbor lists.
	 */
	
	for (i=1; i<=vertices; i++)
	{
		neighbors[i]=(int *)malloc((deg[i]+1)*sizeof(int));
		if (neighbors[i]==NULL)
		{
			printf("Storage allocation failed.\n");
			exit(1);
		};
		count=0;
		for (j=1; j<=vertices; j++)
		{
			if (table[ijtok(i,j,vertices)]=='x')
			{
				count++;
				neighbors[i][count]=j;
			};
		};
	};	
}

void heuristic(currentnode, vertices, neighbors, deg, bestsol, bestval)
	struct noderec *currentnode;
	int vertices;
	int **neighbors;
	int *deg;
	int *bestsol;
	int *bestval;
{
	int i,j,k;
	int heuristicval=0;
	int heuristicok;

	for(i=1; i<=vertices; i++)
		HEUR_solution[i]=currentnode->vals[i];
	
	for (i=1; i<=vertices; i++)
	{
		if (HEUR_solution[i]==1)
			heuristicval++;

		if (HEUR_solution[i]==-1)
		{
			heuristicok=1;
			
			for (k=1; k<=deg[i]; k++)
			{
				j=neighbors[i][k];
				if (HEUR_solution[j]==1)
				{
					heuristicok=0;
					break;
				};
			};
			
			if (heuristicok==1)
			{
				HEUR_solution[i]=1;
				heuristicval++;
			}
			else
			{
				HEUR_solution[i]=0;
			};
		};
	};
	
	if (heuristicval > (*bestval))
	{
		for (i=1; i<=vertices; i++)
			bestsol[i]=HEUR_solution[i];
		
		(*bestval)=heuristicval;
		printf("New best solution from heuristic %d \n",(*bestval));
	};
}



double thetabound(nodes,neighbors,deg,currentnode,bestval)
     int nodes;
     int **neighbors;
     int *deg;
     struct noderec *currentnode;
     int bestval;
{
  double bound;
  double base;
  int i,j,k;
  int reducednodes, reducededges;
  int indexi, indexj;
  int count;
  double tempx;
  int tempi;

  /*
   * Storage for the problem.
   */

  struct blockmatrix C;
  struct blockmatrix X,Z;
  double *y;
  double pobj,dobj;
  double *a;
  struct constraintmatrix *constraints;
  int ret;
  int foo;

	BESTVAL = bestval;
	CURRENTLEVEL = currentnode->level;

  /*
   * Get the base amount first.
   */

  base=0.0;
  for (i=1; i<=nodes; i++)
    {
      if (currentnode->vals[i]==1)
	base=base+1.0;
    };

  /*
   * Now, figure out how many nodes and edges are in the reduced graph.
   */

  reducednodes=0;
  for (i=1; i<=nodes; i++)
    {
      if (currentnode->vals[i]==-1)
	reducednodes++;
    };

  /* printf("nodes %d\n",reducednodes); */

  reducededges=0;
  for (i=1; i<=nodes; i++)
    {
      if (currentnode->vals[i]==-1)
	{
	  for (k=1; k<=deg[i]; k++)
	    {
	      if (currentnode->vals[neighbors[i][k]]==-1)
		{
		  j=neighbors[i][k];
		  if (i<j)
		    reducededges++;
		};
	    };
	};
    };

  /*
   * Compute the mapping from old node numbers to reduced node numbers.
   */

  count=0;
  for (i=1; i<=nodes; i++)
    {
      if (currentnode->vals[i]==-1)
	{
	  count++;
	  nodemap[i]=count;
	}
      else
	{
	  nodemap[i]=0;
	};
    };

  if (reducededges==0)
    {
      bound=base+reducednodes;
      return(bound);
    };

  /*
   * Now, setup the Lovasz theta problem.
   */


  /*
   *  Setup the objective function and the constraints.
   */

  C.nblocks=1;
  C.blocks=malloc(2*sizeof(struct blockrec));
  if (C.blocks == NULL)
    {
      printf("Couldn't allocate storage for C!\n");
      exit(1);
    };

  C.blocks[1].blockcategory=MATRIX;
  C.blocks[1].blocksize=reducednodes;
  C.blocks[1].data.mat=(double *)
    malloc(reducednodes*reducednodes*sizeof(double));
  if (C.blocks[1].data.mat == NULL)
    {
      printf("Couldn't allocate storage for C!\n");
      exit(1);
    };

  for (i=1; i<=reducednodes; i++)
    for (j=1; j<=reducednodes; j++)
      C.blocks[1].data.mat[ijtok(i,j,reducednodes)]=1.0;

  /*
   *  There are reducededges+1 constraints.
   */

  constraints=(struct constraintmatrix *)
    malloc((reducededges+2)*sizeof(struct constraintmatrix));

  if (constraints==NULL)
    {
      printf("Failed to allocate storage for constraints!\n");
      exit(1);
    };

  a=(double *)malloc((reducededges+2)*sizeof(double));
  if (a==NULL)
    {
      printf("Failed to allocate storage for a!\n");
      exit(1);
    };

  /*
   *  Constraint 1 says that Trace(X)=1.
   */

  a[1]=1.0;
  constraints[1].blocks=(struct sparseblock *)malloc(sizeof(struct sparseblock));

  constraints[1].blocks->blocknum=1;
  constraints[1].blocks->numentries=reducednodes;
  constraints[1].blocks->blocksize=reducednodes;
  constraints[1].blocks->constraintnum=1;
  constraints[1].blocks->next=NULL;
  constraints[1].blocks->nextbyblock=NULL;

  constraints[1].blocks->entries=(double *) malloc((reducednodes+1)*sizeof(double));
#ifdef NOSHORTS
  constraints[1].blocks->iindices=(int *) malloc((reducednodes+1)*sizeof(int));
  constraints[1].blocks->jindices=(int *) malloc((reducednodes+1)*sizeof(int));
#else
  constraints[1].blocks->iindices=(unsigned short *) malloc((reducednodes+1)*sizeof(unsigned short));
  constraints[1].blocks->jindices=(unsigned short *) malloc((reducednodes+1)*sizeof(unsigned short));
#endif

  for (i=1; i<=reducednodes; i++)
    {
      constraints[1].blocks->entries[i]=1.0;
      constraints[1].blocks->iindices[i]=i;
      constraints[1].blocks->jindices[i]=i;
    };

  /*
   *  Constraints 2 through m+1 enforce X(i,j)=0 when (i,j) is an edge.
   */

  count=1;
  for (i=1; i<=nodes; i++)
    {
      if (currentnode->vals[i]==-1)
	{
	  for (k=1; k<=deg[i]; k++)
	    {
	      if ((currentnode->vals[neighbors[i][k]]==-1) &&
		  (i < neighbors[i][k]))
		{
		  indexi=nodemap[i];
		  indexj=nodemap[neighbors[i][k]];
		  count++;
		  a[count]=0.0;
		  
		  constraints[count].blocks=(struct sparseblock *)
		    malloc(sizeof(struct sparseblock));

		  constraints[count].blocks->blocknum=1;
		  constraints[count].blocks->numentries=1;
		  constraints[count].blocks->blocksize=reducednodes;
		  constraints[count].blocks->constraintnum=count;
		  constraints[count].blocks->next=NULL;
		  constraints[count].blocks->nextbyblock=NULL;
      
		  constraints[count].blocks->entries=(double *) malloc((2)*sizeof(double));
#ifdef NOSHORTS
		  constraints[count].blocks->iindices=(int *) malloc((2)*sizeof(int));
		  constraints[count].blocks->jindices=(int *) malloc((2)*sizeof(int));
#else
		  constraints[count].blocks->iindices=(unsigned short *) malloc((2)*sizeof(unsigned short));
		  constraints[count].blocks->jindices=(unsigned short *) malloc((2)*sizeof(unsigned short));
#endif

		  constraints[count].blocks->entries[1]=1.0;
		  constraints[count].blocks->iindices[1]=indexi;
		  constraints[count].blocks->jindices[1]=indexj;
		};
	    };
	};
    };


  /*
   *  Create an initial solution.
   */

  initsoln(reducednodes,reducededges+1,C,a,constraints,&X,&y,&Z);

  /*
   * Actually, write over the solution with our own.
   */

  for (i=1; i<=reducednodes; i++)
    X.blocks[1].data.mat[ijtok(i,i,reducednodes)]=1.0/reducednodes;
  
  y[1]=2.0*reducednodes;
  for (i=2; i<=reducededges+1; i++)
    y[i]=0.0;

  for (i=1; i<=reducednodes; i++)
    Z.blocks[1].data.mat[ijtok(i,i,reducednodes)]=2.0*reducednodes;

  for (j=1; j<=reducednodes; j++)
    for (i=1; i<=reducednodes; i++)
      Z.blocks[1].data.mat[ijtok(i,j,reducednodes)]=
	Z.blocks[1].data.mat[ijtok(i,j,reducednodes)]-1.0;

  /*
   *  Use easy_sdp() to solve the problem.
   */

  ret=easy_sdp(reducednodes,reducededges+1,C,a,constraints,base,&X,&y,&Z,&pobj,&dobj);

  if (ret == 0)
    {;
      /*    printf("The Lovasz Theta Number is %.7e \n",(dobj+pobj)/2); */
    }
  else
    {
      printf("SDP failed.\n");
      exit(1);
    };

  /*
   * Now, figure out the variable to branch on.
   */

  for (i=1; i<=reducednodes; i++)
    xvalues[i]=-X.blocks[1].data.mat[ijtok(i,i,reducednodes)];
  for (j=1; j<=reducednodes; j++)
    for (i=1; i<=reducednodes; i++)
      xvalues[j] = xvalues[j]+2*X.blocks[1].data.mat[ijtok(i,j,reducednodes)];

  for (i=1; i<=nodes; i++)
    {
      if (nodemap[i] != 0)
	reducednodenumbers[nodemap[i]]=i;
    };

  for (i=1; i<=reducednodes-1; i++)
    for (j=i+1; j<=reducednodes; j++)
      {
	if (xvalues[i] < xvalues[j])
	  {
	    tempi=reducednodenumbers[i];
	    tempx=xvalues[i];
	    reducednodenumbers[i]=reducednodenumbers[j];
	    xvalues[i]=xvalues[j];
	    reducednodenumbers[j]=tempi;
	    xvalues[j]=tempx;
	  };
      };
  /*
   * Save this information for deciding what node to branch on.
   */

  foo=1;

  for (i=foo; i<=foo+29; i++)
    currentnode->branchingvertices[i+1-foo]=reducednodenumbers[i];

  /*
   *
   */

  free_prob(reducednodes,reducededges+1,C,a,constraints,X,y,Z);

  bound=dobj;

  return(bound);

}

/*
 * User exit routine for psd.  This version of the routine simply returns
 * 0, so that psd will not stop.
 */

int user_exit(n,k,C,a,dobj,pobj,constant_offset,constraints,X,y,Z,params)
     int n;
     int k;
     struct blockmatrix C;
     double *a;
     double dobj;
     double pobj;
     double constant_offset;
     struct constraintmatrix *constraints;
     struct blockmatrix X;
     double *y;
     struct blockmatrix Z;     
     struct paramstruc params;
{
  double relpinfeas,reldinfeas;

  work.blocks[1].blocksize=C.blocks[1].blocksize;

  reldinfeas=dinfeas(k,C,constraints,y,Z,work);
  relpinfeas=pinfeas(k,constraints,X,a,workvec);

  if ((reldinfeas < params.atytol) &&
      (dobj<BESTVAL+0.995))
    {
      return(1);
    };

  if ((reldinfeas < params.atytol) &&
      (relpinfeas < params.axtol) &&
      (pobj>BESTVAL+0.995))
    {
      /*
       * We can never fathom this node, so give up on bounding it, unless
       * we're current at level 1.  In that case, keep going.
       */
      if (CURRENTLEVEL==1) 
	return(0);
      else
	return(1);
    };

  /*
   * We're not done yet.
   */

  return(0);

}

