#include "graphtools.h"

/* 
 * globals for calls to lapack
 */

char LPK_jobz, LPK_range, LPK_uplo;
double LPK_vl,LPK_vu,LPK_abstol;
int LPK_il,LPK_iu,LPK_incx,LPK_info;
double *LPK_evals;
double *LPK_evects;
double *LPK_work;
int LPK_lwork,LPK_liwork;
int *LPK_iwork;
int *LPK_ifail;
int *LPK_isuppz;

/* 
 * globals for the bpm problem
 */

double *BPM_Z;
double *BPM_W;
double *BPM_y;			
double *BPM_Aty;				
double *BPM_X;
double *BPM_work;
int USE_DSYEVX;

/*
 * globals for the last bounded problem
 */
 
int *OLD_toReduced;
int OLD_vertices;
int OLD_edges;
int *OLD_reducedEdges;
int *newEdgeToOld;
int *newNodeToOld;
double *OLD_y;
double *OLD_X;

/*
* Storage for a heuristic solution
*/

int *HEUR_solution;




void initializeGraphTools(vertices, edges)
	int vertices;
	int edges;
{
	int i;
	
    /* 
	 * allocation of space for functions called that use dsyevx
	 */

	
	LPK_evals = (double *)malloc(vertices*sizeof(double));
	LPK_evects = (double *)malloc(vertices*vertices*sizeof(double));
	LPK_lwork = 300*vertices;
	LPK_work = (double *)malloc(LPK_lwork*sizeof(double));
	LPK_liwork = 12*vertices;
	LPK_iwork = (int *)malloc(LPK_liwork*sizeof(int));
	LPK_ifail = (int *)malloc(vertices*sizeof(int));
	LPK_isuppz = (int *)malloc(vertices*2*sizeof(int));
	
	if( (LPK_evals == NULL) || (LPK_evects == NULL) || (LPK_work == NULL) ||
		(LPK_iwork == NULL) || (LPK_ifail == NULL) ) {
			printf("Memory allocatoin failed for dsyevx\n");
			exit(1);
	}

	/*
	 * alloctaion of space for the theta problem
	 */
	
	BPM_Z = (double *)malloc(vertices*vertices*sizeof(double));
	BPM_W = (double *)malloc(vertices*vertices*sizeof(double));
	BPM_y = (double *)malloc((edges+1)*sizeof(double));
	BPM_Aty = (double *)malloc(vertices*vertices*sizeof(double));
	BPM_X = (double *)malloc(vertices*vertices*sizeof(double));
	BPM_work = (double *)malloc(vertices*vertices*sizeof(double));


	if( (BPM_y == NULL) || (BPM_Aty == NULL) || (BPM_W == NULL) || 
		(BPM_Z == NULL) || (BPM_X == NULL) || (BPM_work == NULL)) {
		printf("Error: memory allocation failed for augLagTheta\n");
		exit(1);
	}
	
	/*
	 * memory allocation for storage of previous problems
	 */
	 
	 	
	OLD_toReduced = (int *)malloc((vertices+1)*sizeof(int));
	OLD_reducedEdges = (int *)malloc(2*edges*sizeof(int));
	newEdgeToOld = (int *)malloc(edges*sizeof(int));
	newNodeToOld = (int *)malloc(vertices*sizeof(int));
	OLD_X = (double *)malloc(vertices*vertices*sizeof(double));
	OLD_y = (double *)malloc((edges+1)*sizeof(double));
	
	/*
	 * allocate space for the heuristic solution
	 */
	 
	HEUR_solution=(int *)malloc((vertices+1)*sizeof(int));
	if (HEUR_solution==NULL)
	{
		printf("Storage allocation failed!\n");
		exit(1);
	};
	
	for (i=1; i<=vertices; i++)
		HEUR_solution[i]=-1;

}

void destroyGraphTools() 
{
	free(LPK_evals);
	free(LPK_evects);
	free(LPK_work);
	free(LPK_iwork);
	free(LPK_ifail);
	free(BPM_Z);
	free(BPM_W);
	free(BPM_y);
	free(BPM_Aty);
	free(BPM_X);
	free(BPM_work);
	free(OLD_toReduced);
	free(newEdgeToOld);
	free(newNodeToOld);
	free(OLD_X);
	free(OLD_y);
}

void cliqueSearch(currentnode, table, vertices, neighbors, deg)
	struct noderec *currentnode;
	char *table;
	int vertices;
	int **neighbors;
	int *deg;
{	
	int i,j,k,kk,count;
	int cliqueok;
	int foundclique = 1;
	
	while (foundclique==1)
	{
		foundclique=0;
		
		for (i=1; i<=vertices; i++)
		{
			if (currentnode->vals[i]==-1)
			{
				/* 
				* Check to see whether the neighbors of this node form a clique.
				*/
				
				cliqueok=1;
				for (k=1; k<=deg[i]-1; k++)
				{
					j=neighbors[i][k];
					
					if (currentnode->vals[j]==-1)
					{
						for (kk=k+1; kk<=deg[i]; kk++)
						{
							if ((table[ijtok(j,(neighbors[i][kk]),vertices)] != 'x') &&
								(currentnode->vals[neighbors[i][kk]]==-1))
							{
								cliqueok=0;
								break;
							}
						};
						
						if (cliqueok==0)
							break;
					};
				};
				
				if (cliqueok==1)
				{
					/*
					 * found a clique, set one node to 1, the others to 0 
					 */
					currentnode->vals[i]=1;
					count=0;
					
					for (k=1; k<=deg[i]; k++)
					{
						if (currentnode->vals[neighbors[i][k]]==-1)
						{
							count++;
							currentnode->boundest=currentnode->boundest-0.05;
							currentnode->vals[neighbors[i][k]]=0;
						};
					};

#ifdef VERBOSE
					printf("Found a node-and-clique, node=%d, size=%d\n",i,count);
					fflush(stdout);
#endif

					/*
					 * We've changed the unset subgraph, search for cliques again
					 */
					 
					foundclique=1;
				};
			}; 
		};
	};
}

void createNeighbors(table, vertices, neighbors, deg)
	char *table;
	int vertices;
	int **neighbors;
	int *deg;
{
	int i,j,count;
	
	for (j=1; j<=vertices; j++)
	{
		deg[j]=0;
		for (i=1; i<=vertices; i++)
		{
			if (table[ijtok(i,j,vertices)]=='x')
			deg[j]=deg[j]+1;
		};
	};
	
	/*
	 * Make up neighbor lists.
	 */
	
	for (i=1; i<=vertices; i++)
	{
		neighbors[i]=(int *)malloc((deg[i]+1)*sizeof(int));
		if (neighbors[i]==NULL)
		{
			printf("Storage allocation failed.\n");
			exit(1);
		};
		count=0;
		for (j=1; j<=vertices; j++)
		{
			if (table[ijtok(i,j,vertices)]=='x')
			{
				count++;
				neighbors[i][count]=j;
			};
		};
	};	
}

void heuristic(currentnode, vertices, neighbors, deg, bestsol, bestval)
	struct noderec *currentnode;
	int vertices;
	int **neighbors;
	int *deg;
	int *bestsol;
	int *bestval;
{
	int i,j,k;
	int heuristicval=0;
	int heuristicok;

	for(i=1; i<=vertices; i++)
		HEUR_solution[i]=currentnode->vals[i];
	
	for (i=1; i<=vertices; i++)
	{
		if (HEUR_solution[i]==1)
			heuristicval++;

		if (HEUR_solution[i]==-1)
		{
			heuristicok=1;
			
			for (k=1; k<=deg[i]; k++)
			{
				j=neighbors[i][k];
				if (HEUR_solution[j]==1)
				{
					heuristicok=0;
					break;
				};
			};
			
			if (heuristicok==1)
			{
				HEUR_solution[i]=1;
				heuristicval++;
			}
			else
			{
				HEUR_solution[i]=0;
			};
		};
	};
	
	if (heuristicval > (*bestval))
	{
		for (i=1; i<=vertices; i++)
			bestsol[i]=HEUR_solution[i];
		
		(*bestval)=heuristicval;
		printf("New best solution from heuristic %d \n",(*bestval));
	};
}


int constructReducedGraph(vertices,currentNode,neighbors,deg,nReducedNodes,nReducedEdges,
						  reducedEdges,toReduced,base) 
	int vertices;
	struct noderec *currentNode;
	int **neighbors;
	int *deg;
	int *nReducedNodes;
	int *nReducedEdges;
	int *reducedEdges;
	int *toReduced;
	double *base;
{
	int i,j,k,oldHelps;
	
	/* 
	 * base stores the tally of all nodes set to 1
	 */
	
	*base = 0.0;
	*nReducedNodes = 0;
	*nReducedEdges = 0;
	oldHelps = 1;
	
	for(i=1; i<=vertices; i++) {
		if( currentNode->vals[i] == -1 ) {
			*nReducedNodes = *nReducedNodes + 1;
			toReduced[i] = *nReducedNodes;
		} else {
			toReduced[i] = 0;
		}
	}
	
	for(i=1; i<=vertices; i++) {
		if( currentNode->vals[i] == 1)
			*base = *base + 1.0;
		else if( currentNode->vals[i] == -1 ) {			
			
			if( oldHelps == 1 ) {
				newNodeToOld[toReduced[i]] = OLD_toReduced[i];
				if( OLD_toReduced[i] == 0 ) {
					oldHelps = 0;
				}
			}
			
			for(k=1; k<=deg[i]; k++) {
				j = neighbors[i][k];
				if( ( currentNode->vals[j] == -1 ) &&
					( i<j) ){
					
					if( oldHelps == 1) {
						newEdgeToOld[*nReducedEdges] = inOld(i,j);
					
						if(newEdgeToOld[*nReducedEdges] == -1) {
							oldHelps = 0;
						}
					}
										
					reducedEdges[2*(*nReducedEdges)] = toReduced[i];
					reducedEdges[2*(*nReducedEdges)+1] = toReduced[j];
					
					*nReducedEdges = *nReducedEdges + 1;
				};
			};
		} else {
			toReduced[i] = 0;
		};
	};
			
	if( oldHelps == 1 ) {
#ifdef VERBOSE
#ifndef NOOLDY
		printf("Using previous y\n");
#endif
#endif

		return 1;
	}
	
	return 0;
}

int yOldFathoms(edges,nEdges,vertices,bestval,base) 
	int *edges;
	int nEdges;
	int vertices;
	int bestval;
	double base;
{ 
	int i,m;
	
	for(i=0; i<vertices*vertices; i++) {
		BPM_work[i] 	= -1.0;
	}
	
	for(i=0;i<nEdges;i++) {
		BPM_work[ijtok(edges[2*i],edges[2*i+1],vertices)] = OLD_y[newEdgeToOld[i]]-1.0;
		BPM_work[ijtok(edges[2*i+1],edges[2*i],vertices)] = OLD_y[newEdgeToOld[i]]-1.0;
	}
	
	for(i=1;i<=vertices;i++) 
		BPM_work[ijtok(i,i,vertices)] = bestval-base-1.0-0.01;
		
	/* 
	 *	compute smallest eigenvalue
	 */
	LPK_jobz = 'N';
	LPK_range = 'I';
	LPK_uplo = 'U';
	LPK_abstol = -1.0;
	LPK_info = 0;
	LPK_il = 1;
	LPK_iu = 1;

	dsyevr_(&LPK_jobz,&LPK_range,&LPK_uplo,&vertices,BPM_work,&vertices,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,
			&m,LPK_evals,LPK_evects,&vertices,LPK_isuppz,LPK_work,&LPK_lwork,LPK_iwork,&LPK_liwork,&LPK_info);
#ifdef VERBOSE
	printf("attempting to use previous y, smallest eval is %f\n",LPK_evals[0]);
#endif
	if( (LPK_info == 0) && (LPK_evals[0] > 1.0e-8) ) 
		return(1);
	return(0);
}


double thetaBound(edges,nEdges,vertices,toReduced,bestval,base,totalVertices,currentnode,oldHelps)
     int *edges;
     int nEdges;
     int vertices;
     int *toReduced;
     int bestval;
     double base;
     int totalVertices;
     struct noderec *currentnode;
     int oldHelps;
{
	double *xvalues,*reducednodenumbers;
	double bound;
	int i,j;
	double tempx;
	int tempi;

	if(oldHelps == 1) {
		for(i=1;i<=vertices;i++)
			for(j=1;j<=vertices;j++)
				BPM_X[ijtok(i,j,vertices)] = OLD_X[ijtok(newNodeToOld[i],newNodeToOld[j],OLD_vertices)];
				
		bound = augLagTheta(edges, nEdges, vertices, base, bestval, currentnode->level,1);
	} else {
		bound = augLagTheta(edges, nEdges, vertices, base, bestval, currentnode->level,0);
	}
  
  if(bound>bestval+0.99) {
  	/* 
  	* copy toReduced into oldNodeMap and X into oldX
  	*/

  	OLD_vertices = vertices;
  	OLD_edges = nEdges;
  	for(i=1;i<=totalVertices;i++)
  		OLD_toReduced[i] = toReduced[i];
  	for(i=0;i<2*nEdges;i++)
  		OLD_reducedEdges[i] = edges[i];
  	for(i=0;i<vertices*vertices;i++)
  		OLD_X[i] = BPM_X[i];
  	for(i=0; i<=nEdges; i++)
  		OLD_y[i] = BPM_y[i];
  }

  /*
   * Now, figure out the variable to branch on.
   * I split up BPM_work using pointers
   */

	xvalues = BPM_work;
	reducednodenumbers = BPM_work + vertices;
	

  for (i=1; i<=vertices; i++)
    xvalues[i]=-BPM_X[ijtok(i,i,vertices)];
  for (j=1; j<=vertices; j++)
    for (i=1; i<=vertices; i++)
      xvalues[j] = xvalues[j]+2*BPM_X[ijtok(i,j,vertices)];

  for (i=1; i<=totalVertices; i++)
    {
      if (toReduced[i] != 0)
	reducednodenumbers[toReduced[i]]=i;
    };

  for (i=1; i<=vertices-1; i++)
    for (j=i+1; j<=vertices; j++)
      {
	if (xvalues[i] < xvalues[j])
	  {
	    tempi=reducednodenumbers[i];
	    tempx=xvalues[i];
	    reducednodenumbers[i]=reducednodenumbers[j];
	    xvalues[i]=xvalues[j];
	    reducednodenumbers[j]=tempi;
	    xvalues[j]=tempx;
	  };
      };
  /*
   * Save this information for deciding what node to branch on.
   */


  for (i=1; i<=30; i++)
    currentnode->branchingvertices[i]=reducednodenumbers[i];

  /*
   *
   */

  return(bound);

}

int inOld(nodeOne,nodeTwo) 
	int nodeOne;
	int nodeTwo;
{
	int i;

	for(i=0;i<OLD_edges;i++) {
		if(OLD_reducedEdges[2*i] == OLD_toReduced[nodeOne]) 
			if(OLD_reducedEdges[2*i+1] == OLD_toReduced[nodeTwo])
				return(i);
		if(OLD_reducedEdges[2*i] == OLD_toReduced[nodeTwo])
			if(OLD_reducedEdges[2*i+1] == OLD_toReduced[nodeOne])
				return(i);
	}
	
	return(-1);
}

double augLagTheta(edges, nEdges, vertices, base, goal, level, useX)
	int *edges;
	int nEdges;			/* number of edges */
	int vertices;			/* number of nodes */
	double base;		/* constant offset for objective functions */
	int goal;			/* integer bound desired */
	int level;			/* level of current node */
	int useX;
{	
	double bound;		/* bound to be returned */
	double sigma,trace;		
	int nneg = vertices; 			/* number of negative eigenvalues last found */
	int i;						/* indeces, counters */
	int done = 0;				/* boolean */
	int iters = 0;				/* iterations count */
	double primal,dual;			/* (possibly infeasible) dual objective value */
	double err_p,err_d;			/* error measures */
	const double tol = 1.0e-5;	/* tolerance */
	const int max_iters = 2000; /* maximum number of iterations */
	
	/*
	 * start with dsyevr 
	 */
	
	USE_DSYEVX = 0;
	
	/*
	 *	choose starting sigma
	 */
	
	if( vertices <= 250 )
		sigma = 0.1/vertices;
	else
		sigma = 0.05/vertices;
	
	/* 
	 *	zero the variables
	 */

	for(i=0; i<vertices*vertices; i++) {
		BPM_Aty[i]	= 0.0;
		BPM_W[i] 	= 0.0;
		BPM_Z[i] 	= 0.0;
	}
	
	if(useX == 0) {
		for(i=0; i<vertices*vertices; i++) 
			BPM_X[i] = 0.0;
	} else {
#ifdef VERBOSE
#ifndef NOOLDX
		printf("using old X\n");
#endif
#endif
	}

#ifdef VERBOSE
	printf(" it    dual       primal    lg10(r-d   r-p    sigma) \n");
	fflush(stdout);
#endif

	while( done == 0 ) {
		iters++;
		
		/* 	
		 *	solve for y 
		 *		AA^T(y)=A(BPM_Z+C+1/sigma*X)-1/sigma*b
		 */
		
		for(i=0;i<nEdges;i++)
			BPM_y[i] = 	BPM_Z[ijtok(edges[2*i],edges[2*i+1],vertices)]+1+
					BPM_X[ijtok(edges[2*i],edges[2*i+1],vertices)]/sigma;
		
		trace = 0;
		
		for(i=1;i<=vertices;i++) 
			trace += BPM_Z[ijtok(i,i,vertices)] + 1 + BPM_X[ijtok(i,i,vertices)]/sigma;
		
		BPM_y[nEdges] = (trace-1/sigma)/vertices;	
		
		 
		/* 
		 *	compute Aty=A^T(y) 
		 */
		
		for(i=0;i<nEdges;i++) {
			BPM_Aty[ijtok(edges[2*i],edges[2*i+1],vertices)] = BPM_y[i];
			BPM_Aty[ijtok(edges[2*i+1],edges[2*i],vertices)] = BPM_y[i];
		}
		
		for(i=1;i<=vertices;i++) 
			BPM_Aty[ijtok(i,i,vertices)] = BPM_y[nEdges];
		 
		/*	
		 *	compute BPM_W = A^T(y)-C-1/sigma*X 
		 */
		 
		for(i=0;i<vertices*vertices;i++)
			BPM_W[i] = BPM_Aty[i] - 1 - BPM_X[i]/sigma;
		 
		/*	
		 *	compute eigenvector decomposition of BPM_W 
		 *		BPM_W = P*L*P^T
		 *	Split the eigenvector decomposition 
		 *	into matrices corresponding to positive
		 *	and negative eigenvalues
		 *	BPM_W = Wp + Wn, BPM_Z=Wp, X=-sigma*Wn
		 */
		 		 
		if( eigSplit(vertices,&nneg,sigma) == 1) {
				
			/*
			 * Compute error values
			 */
					 
			err_p = 0.0;
			for(i=0;i<nEdges;i++) 
				err_p += pow( 2*BPM_X[ijtok(edges[2*i],edges[2*i+1],vertices)], 2);
			trace = 0.0;
			for(i=1;i<=vertices;i++)
				trace += BPM_X[ijtok(i,i,vertices)];
			err_p += pow(trace-1,2);
			err_p = sqrt(err_p);
			
			err_d = 0.0;
			for(i=0;i<vertices*vertices;i++)
				err_d += pow(BPM_Z[i]-BPM_Aty[i]+1,2);
			err_d = sqrt(err_d);
			 
			/* 
			 *	compute objective values
			 */
			
			primal = base;
			for(i=0;i<vertices*vertices;i++)
				primal = primal+BPM_X[i];
			dual = base + BPM_y[nEdges];
			
			/* 
			 *	print some output
			 */
	
/*#ifdef VERBOSE
			if(iters%40==0) {
				printf("%3d %11.7f %11.7f %7.2f %7.2f %8.4f\n", iters, dual, primal,
					log10(err_d/(vertices+1)), log10(err_p/2), log10(sigma));
				fflush(stdout);
			}
#endif*/
	
			/* 
			 * adjust sigma
			 */
			 
			if(err_d>5000*err_p)
				sigma = sigma*1.005;
			if(err_p>5000*err_d)
				sigma = sigma*0.995;
			 
			 
			/* decide if done */
			if( /* decent convergence and no chance of fathoming , not in first node */
				( ( primal*(1-err_p) > goal+0.99 ) && ( err_p < tol*1.0e2 ) && ( level != 1) ) ||
				/* achived desired tolerance */
				( ( err_p/2 < tol ) && ( err_d/vertices < tol) ) ||
#ifndef NOLIMIT
				( iters == max_iters ) ||
#endif
				/* fathomed node */
				( (dual < goal+0.99) && (fathomed(vertices, goal, base) == 1 ))) {
			
				bound = forceDual(vertices,dual);
				
#ifdef VERBOSE
		/*		if(iters%40 != 0) {*/
					printf("%3d %11.7f %11.7f %7.2f %7.2f %8.4f %9.5f\n", iters, dual, primal,
						log10(err_d/(vertices+1)), log10(err_p/2), log10(sigma), bound);
/*				}*/
	
				if(iters == max_iters) 
					printf("Maximum iterations reached\n");
				else
					printf("Normal termination\n");
#endif
	
				done++;
			}
		}
	}
	
	return(bound);
}



/*
 * eigSplit
 */

int eigSplit(n,m,sigma) 
	int n;
	int *m;
	double sigma;
{
	int i,j;
	double alpha;	

	/*
	 *	Variables for lapack's eigenvalue decomposition and blas' outer product
	 */
	
	LPK_jobz = 'V';
	LPK_range = 'V';
	LPK_uplo = 'U';
	LPK_il = 1;
	LPK_iu = 1;
	LPK_abstol = 1.0e-5;
	LPK_info = 0;
	LPK_incx = 1;
	

	/*
	 *	If the last iteration had mostly positive eigenvalues, compute the negative ones
	 *	only. If mostly negative, compute the positive ones
	 */
	
	if(*m<n/2) {
		/*
		 * find all the negative eigenvalues
		 */
		 
		LPK_vl = -1.0e30;
		LPK_vu = 0.0;
		
		if( USE_DSYEVX == 0) {
			dsyevr_(&LPK_jobz,&LPK_range,&LPK_uplo,&n,BPM_W,&n,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,
					m,LPK_evals,LPK_evects,&n,LPK_isuppz,LPK_work,&LPK_lwork,LPK_iwork,&LPK_liwork,&LPK_info); 
		} else {
			dsyevx_(&LPK_jobz,&LPK_range,&LPK_uplo,&n,BPM_W,&n,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,
					m,LPK_evals,LPK_evects,&n,LPK_work,&LPK_lwork,LPK_iwork,LPK_ifail,&LPK_info);
		}
				
		if( LPK_info != 0 ) {
			/* 
			 * switch to dsyevx
			 */
#ifdef VERBOSE
			 printf("failed to converge, switching to dsyevx\n"); 
#endif
			 USE_DSYEVX = 1;
			 return(0);
		}
		
		/*
		 *	zero my storage variables
		 */
		for(i=0;i<n*n;i++) {
			BPM_Z[i] = 0.0;
			BPM_work[i] = 0.0;
		}
		
		
		/* 
		 * store the weighted sum of the outer products of the negative
		 * eigenvectors in BPM_work
		 */
		
		for(i=0;i<*m;i++) {
			alpha = LPK_evals[i];
			dsyr_(&LPK_uplo,&n,&alpha,LPK_evects+i*n,&LPK_incx,BPM_work,&n);
		}
		
		/* 
		 *make this BPM_work symmetric 
		 */
		 
		for(i=1;i<=n;i++)
			for(j=i+1;j<=n;j++)
				BPM_work[ijtok(j,i,n)] = BPM_work[ijtok(i,j,n)];
		
		/* 
		 *I need BPM_W again, the ev decomposition overwrote it, so recalculate 
		 */

		for(i=0;i<n*n;i++)
			BPM_W[i] = BPM_Aty[i] - 1 - BPM_X[i]/sigma;				
		
		/* 
		 *calculate the real X and BPM_Z 
		 */
		for(i=0;i<n*n;i++) {
			BPM_Z[i] = BPM_W[i]-BPM_work[i];
			BPM_X[i] = -1*sigma*BPM_work[i];
		}
	} else {
		/*
		 * find all the positive eigenvalues
		 */
		
		LPK_vl = 0.0;
		LPK_vu = 1.0e30;
		if( USE_DSYEVX == 0) {
			dsyevr_(&LPK_jobz,&LPK_range,&LPK_uplo,&n,BPM_W,&n,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,
					m,LPK_evals,LPK_evects,&n,LPK_isuppz,LPK_work,&LPK_lwork,LPK_iwork,&LPK_liwork,&LPK_info); 
		} else {
			dsyevx_(&LPK_jobz,&LPK_range,&LPK_uplo,&n,BPM_W,&n,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,
					m,LPK_evals,LPK_evects,&n,LPK_work,&LPK_lwork,LPK_iwork,LPK_ifail,&LPK_info);
		}
		
		if( LPK_info != 0 ) {
			/* 
			 * switch to dsyevx
			 */
#ifdef VERBOSE
			 printf("failed to converge, switching to dsyevx\n"); 
#endif
			 USE_DSYEVX = 1;
			 return(0);
		}		
		
		/*
		 *	zero my storage variables
		 */
		for(i=0;i<n*n;i++) {
			BPM_Z[i] = 0.0;
			BPM_work[i] = 0.0;
		}
		
		
		/* 
		 * store the weighted sum of the outer products of the positive
		 * eigenvectors in BPM_work
		 */
		
		for(i=0;i<*m;i++) {
			alpha = LPK_evals[i];
			dsyr_(&LPK_uplo,&n,&alpha,LPK_evects+i*n,&LPK_incx,BPM_Z,&n);
		}
		
		/* 
		 * make m the number of negative eigenvalues again
		 */
		
		*m = n-*m;
		
		/* 
		 * make BPM_Z symmetric 
		 */
		
		for(i=1;i<=n;i++)
			for(j=i+1;j<=n;j++)
				BPM_Z[ijtok(j,i,n)] = BPM_Z[ijtok(i,j,n)];
		
		/* 
		 *	recalcculate W 
		 */
		 
		for(i=0;i<n*n;i++)
			BPM_W[i] = BPM_Aty[i] - 1 - BPM_X[i]/sigma;
		
		/* 
		 *calculate X 
		 */
		
		for(i=0;i<n*n;i++) 
			BPM_X[i] = -1*sigma*(BPM_W[i]-BPM_Z[i]);
	}	
	
	return(1);
}


/*
 * 	forceDual
 */

double forceDual(n,dual) 
	int n;
	double dual;
{
	double feasDual,smallEig,largeEig,offset;
	int i,m;
	
	/*
	 *	Variables for lapack's eigenvalue decomposition and blas' outer product
	 */
	
	LPK_jobz = 'N';
	LPK_range = 'I';
	LPK_uplo = 'U';
	LPK_abstol = -1.0;
	LPK_info = 0;

	/* 
	 *	recompute BPM_Z=Aty-L
	 */
	 
	for(i=0;i<n*n;i++)
		BPM_work[i] = BPM_Aty[i]-1;
	 
	/* 
	 *	compute smallest eigenvalue
	 */
	LPK_il = 1;
	LPK_iu = 1;
	dsyevx_(&LPK_jobz,&LPK_range,&LPK_uplo,&n,BPM_work,&n,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,&m,
			LPK_evals,LPK_evects,&n,LPK_work,&LPK_lwork,LPK_iwork,LPK_ifail,&LPK_info);
	smallEig = LPK_evals[0];
	
	/* 
	 * if one is negative, force feasibility
	 */

	if( smallEig<0 ) {
	
		LPK_il = n;
		LPK_iu = n;
		dsyevx_(&LPK_jobz,&LPK_range,&LPK_uplo,&n,BPM_work,&n,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,&m,
				LPK_evals,LPK_evects,&n,LPK_work,&LPK_lwork,LPK_iwork,LPK_ifail,&LPK_info);
		largeEig = LPK_evals[0];
		
		if(largeEig>1.0) 
			offset = 1.0e-12*largeEig;
		else
			offset = 1.0e-12;
			
		feasDual = dual - smallEig + offset;
		
		/* 
		 *	do it again to check 
		 */
		
		for(i=0; i<n*n; i++)
			BPM_work[i] = BPM_Aty[i]-1;
		for(i=1; i<=n; i++)
			BPM_work[ijtok(i,i,n)] = BPM_work[ijtok(i,i,n)] - smallEig + offset;

		LPK_il = 1;
		LPK_iu = 1;
	/*	dsyevx_(&LPK_jobz,&LPK_range,&LPK_uplo,&n,BPM_work,&n,&LPK_vl,&LPK_vu,&LPK_il,&LPK_iu,&LPK_abstol,&m,LPK_evals,LPK_evects,&n,LPK_work,&LPK_lwork,LPK_iwork,LPK_ifail,&LPK_info); */
		dpotrf_(&LPK_uplo, &n, BPM_work, &n, &LPK_info); 

		if( LPK_info != 0 ) {
			feasDual = 1.0e30;
			
#ifdef VERBOSE
			printf("Warning: dual feasibility not achieved, lowest eval is %f\n",LPK_evals[0]);
			fflush(stdout);
#endif
		}

	} else {
		feasDual = dual;
	}
	
	return(feasDual);
}

int fathomed(n,goal,base) 
	int n;
	double goal;
	double base;
{
	int i;
	
	/*
	 *	Variables for lapack's eigenvalue decomposition and blas' outer product
	 */
	LPK_uplo = 'U';
	LPK_info = 0;

	/* 
	 *	recompute BPM_Z=BPM_Aty-L
	 */
	 
	for(i=0;i<n*n;i++)
		BPM_work[i] = BPM_Aty[i]-1;
		
	for(i=1;i<=n;i++)
		BPM_work[ijtok(i,i,n)] = goal-base-0.01;
	 
	dpotrf_(&LPK_uplo, &n, BPM_work, &n, &LPK_info); 

	if(LPK_info == 0) {
		return(1);
	}
	else
		return(0);
}
