#ifndef MIS_BPM_FILETOOLS
#define MIS_BPM_FILETOOLS

#include <stdio.h>
#include <stdlib.h>
#include "declarations.h"

int max_line_length();
int get_line();
char * readProblem(int argc, char *argv[], int *vertices, int *edges, int *bestval);
/* readProblem

reads the problem from files specified in the command line arguments

Input:
	argc, argv		command line arguments:
						argv[1] 	graph filename
						argv[2]		size of larges independent set known on this graph
Output:
	vertices		number of vertices in the graph
	edges			number of edges in the graph
	bestval			argv[2]
	returns a pointer an adjacency matrix stored as a vector according to ijtok found in 
		declarations.h. Edjes are denoted with 'x', otherwise ' '. 
*/

void readFixed(int argc, char *argv[], int *vals, int *deg, int **neighbors);
/* readFixed

reads a file argv[3] that specifies any vertices that should be fixed in or out of the graph before
bandb is started
*/

#endif
