#include "filetools.h"

char *readProblem(argc, argv, nodes, edges, bestval)
	/* input: arguments */
	int argc;
	char *argv[];
	/* output: number of nodes and edges */
	int *nodes;
	int *edges;
	/* output: size of the largest known independent set */
	int *bestval;
{

	char *table;
	FILE *fidin;
	/* buffer for reading files*/
	int buflen;
	char * buf;
	/* temporary storage */
	int ret, count, i, j, indexi, indexj;
	int n,m;	/* storage for nodes and edges */

	/*
	 * Check that we have the correct number of command line parameters.
	 * If not, then output usage info.
	 */ 
	
	if ((argc < 3) || (argc > 4))
	{
		printf("mis_bpm \n");
		printf("Usage: \n");
		printf("\n");
		printf("mis_bpm <graph file> <value of incumbent solution> <fixed variable file>\n");
		exit(1);
	};
	
	/*
	 * Figure out the max line length and allocate a buffer
	 */
	
	fidin=fopen(argv[1],"r");
	if (fidin == (FILE *) NULL)
	{
		printf("Couldn't open problem file for reading! \n");
		exit(1);
	};
	
	buflen=max_line_length(fidin)+10;
	
	fclose(fidin);
	
	buf=(char *)malloc(buflen*sizeof(char));
	if (buf == NULL)
	{
		printf("Storage Allocation for buffer failed.\n");
		exit(1);
	};
	
	/*
	 * Now, reopen the file and get the lines. 
	 */
	
	fidin=fopen(argv[1],"r");
	if (fidin == (FILE *) NULL)
	{
		printf("Couldn't open problem file for reading! \n");
		exit(1);
	};
	
	/*
	 * Get the "p" (problem) line first.
	 */
	
	ret=get_line(fidin,buf,buflen);
	
	while (ret == 0)
	{
	
		if (buf[0]=='p')
		{
			/*
			* We got the problem line.
			*/
			sscanf(buf,"%*s %*s %d %d",&n,&m);
			printf("nodes is %d \n",n);
			printf("edges is %d \n",m);
			break;
		};

		ret=get_line(fidin,buf,buflen);
    };

	if (ret != 0)
	{
		printf("Found no p line!\n");
		exit(1);
	};

	/*
	* Initialize the table
	*/
	
	table=(char *) malloc(n*n*sizeof(char));
	
	for (j=1; j<= n; j++)
		for (i=1; i<= n; i++)
			table[ijtok(i,j,n)]=' ';
	
	/*
	 * Read in the e lines.
	 */
	
	ret=get_line(fidin,buf,buflen);
	count=0;
	
	while (ret == 0)
	{
		if (buf[0]=='e')
		{
			/*
			* We've got an edge.
			*/
			sscanf(buf,"%*s %d %d",&indexi,&indexj);
		/*	printf("Adding edge %d, %d\n",indexi,indexj);	*/
			table[ijtok(indexi,indexj,n)]='x';
			table[ijtok(indexj,indexi,n)]='x';
			count++;
		};
		
		ret=get_line(fidin,buf,buflen);
	};
	
	if (count != m)
	{
		printf("Warning: edges in file does not match p line!\n");
	};

	/*
	 * Compute the number of edges discounting duplicates.
	 */

	m=0;
	for (j=2; j<=n; j++)
		for (i=1; i<j; i++)
		{
			if (table[ijtok(i,j,n)]=='x')
				m++;
		};
	
	/*
	 * Close the input file.
	 */
	
	fclose(fidin);

	/*
	* Get the value of the best incumbent solution from the command line.
	*/
	
	*bestval=atoi(argv[2]);
		
	*nodes = n;
	*edges = m;
	
	
	return(table);
	
}

void readFixed(int argc, char *argv[], int *vals, int *deg, int **neighbors) 
{
	FILE *fidin;
	int i,j,k,l,count;
	
	if (argc == 4)
	{
		fidin=fopen(argv[3],"r");
		if (fidin == (FILE *) NULL)
		{
			printf("Couldn't fixed vars file for reading! \n");
			exit(1);
		};
		
		/*
		 * Determine the number of fixed variables.
		 */
		
		fscanf(fidin,"%d",&count);
		for (i=1; i<=count; i++)
		{
			fscanf(fidin,"%d %d",&j,&k);
			if ((vals[j]==-1)  ||
			((vals[j]==0) && (k==0)) ||
			((vals[j]==1) && (k==1)))
			{
				vals[j]=k;
			}
			else
			{
				printf("Error, this node %d is already fixed at %d.\n",
				j,vals[j]);
				exit(1);
			};
			
			/*
			 * If set to 1, then 0 all neighbors.
			 */
			
			if (k==1)
			{
				for (l=1; l<=deg[j]; l++)
				{
					if (vals[neighbors[j][l]]<=0)
					{
						vals[neighbors[j][l]]=0;
					}
					else
					{
						printf("Error, two neighbors set to 1.\n");
						exit(2);
					};
				};
			};
		};
		
		fclose(fidin);
		
	};

}

int max_line_length(FILE *fid)
{
	int maxlen;
	int k;
	int c;
	
	maxlen=0;
	k=0;
	c=getc(fid);
	while (c != EOF)
	{
		k=0;
		while ((c != '\n') && (c != EOF))
		{
			c=getc(fid);
			k++;
		};
		if (k > maxlen)
			maxlen=k;
		c=getc(fid);
	};
	
	return(maxlen);

}

/*
 *  This routine reads a line of input into a buffer.
 */

int get_line(fid,buffer,bufsiz)
	FILE *fid;
	char *buffer;
	int bufsiz;
{
	int k;
	int c;
	
	k=0;
	c=getc(fid);
	while (c != '\n')
	{
		buffer[k]=c;
		k++;
		c=getc(fid);
		if (c == EOF) 
			return(2);
		if (k >=bufsiz) 
		{
			printf("Line too long in input file!  Adjust BUFFERSIZ in readprob.c\n");
			return(1);
		};
	};
	buffer[k]='\n';
	buffer[k+1]=0;
	
	return(0);
}
