%
%  Y=hankelpts(B)
%
%    B             The transform argument.
%
%  This routine returns a vector of points at which to evaluate the function.
%
%  Based on Walt Anderson's Fortran code, which was published in:
%
%  Anderson, W. L., 1979, Computer Program Numerical Integration of Related
%  Hankel Transforms of Orders 0 and 1 by Adaptive Digital Filtering.
%  Geophysic, 44(7):1287-1305.
%
function Y=hankelpts(B)
%
%  Points at which the function will be evaluated.  Note that these
%  are scaled by B before being used.
%
YBASE=[
   8.9170998013274418e-14
   9.8549193740052245e-14
   1.0891370292130841e-13
   1.2036825704856076e-13
   1.3302749714952345e-13
   1.4701812115404443e-13
   1.6248015192957209e-13
   1.7956833867707590e-13
   1.9845370571306282e-13
   2.1932526413842005e-13
   2.4239190352504162e-13
   2.6788448255287407e-13
   2.9605813952117967e-13
   3.2719484585839035e-13
   3.6160622818693727e-13
   3.9963668718722961e-13
   4.4166684447542096e-13
   4.8811735199247527e-13
   5.3945310203017795e-13
   5.9618788002944785e-13
   6.5888950671771899e-13
   7.2818552104963217e-13
   8.0476946082781583e-13
   8.8940780386232124e-13
   9.8294763913816720e-13
   1.0863251447666186e-12
   1.2005749575703847e-12
   1.3268405280766938e-12
   1.4663855645544968e-12
   1.6206066806315702e-12
   1.7910473730731204e-12
   1.9794134696161976e-12
   2.1875902014670364e-12
   2.4176610713286156e-12
   2.6719287057960000e-12
   2.9529379008172425e-12
   3.2635010908665675e-12
   3.6067264967338821e-12
   3.9860492336431492e-12
   4.4052656910401313e-12
   4.8685715281339743e-12
   5.3806036654647833e-12
   5.9464866927629101e-12
   6.5718841575654077e-12
   7.2630552479033658e-12
   8.0269174363595134e-12
   8.8711157124588670e-12
   9.8040990962934688e-12
   1.0835205199155280e-11
   1.1974753677488471e-11
   1.3234149515479672e-11
   1.4625997169973058e-11
   1.6164226720110948e-11
   1.7864233284247930e-11
   1.9743031099469828e-11
   2.1819423805797136e-11
   2.4114192639334462e-11
   2.6650304417866294e-11
   2.9453141400488783e-11
   3.2550755321790057e-11
   3.5974148143038491e-11
   3.9757582330231206e-11
   4.3938923764369768e-11
   4.8560020715924429e-11
   5.3667122676390673e-11
   5.9311343238745088e-11
   6.5549171659463761e-11
   7.2443038221987792e-11
   8.0061939059983487e-11
   8.8482126693838504e-11
   9.7787873191515278e-11
   1.0807231359173195e-10
   1.1943837803073370e-10
   1.3199982190169224e-10
   1.4588236435691521e-10
   1.6122494654737812e-10
   1.7818112219246310e-10
   1.9692059439719362e-10
   2.1763091409794871e-10
   2.4051935713527238e-10
   2.6581499874015355e-10
   2.9377100619593265e-10
   3.2466717262156566e-10
   3.5881271723520049e-10
   3.9654938012404428e-10
   4.3825484249401899e-10
   4.8434650663021337e-10
   5.3528567339924565e-10
   5.9158215910338558e-10
   6.5379939789346253e-10
   7.2256008080722362e-10
   7.9855238787053352e-10
   8.8253687563437822e-10
   9.7535408908045947e-10
   1.0779329740778886e-09
   1.1913001745856734e-09
   1.3165903076505279e-09
   1.4550573190356333e-09
   1.6080870331313015e-09
   1.7772110227512649e-09
   1.9641219376281762e-09
   2.1706904450210516e-09
   2.3989839519819520e-09
   2.6512872966606394e-09
   2.9301256157327411e-09
   3.2382896168163261e-09
   3.5788635088117363e-09
   3.9552558697009004e-09
   4.3712337607414382e-09
   4.8309604284818817e-09
   5.3390369719324459e-09
   5.9005483919104070e-09
   6.5211144834374116e-09
   7.2069460805369272e-09
   7.9649072163486862e-09
   8.8025838206794284e-09
   9.7283596425381269e-09
   1.0751500157513941e-08
   1.1882245299770154e-08
   1.3131911946747030e-08
   1.4513007182274982e-08
   1.6039353471673310e-08
   1.7726227001629019e-08
   1.9590510569407677e-08
   2.1650862551562963e-08
   2.3927903643240499e-08
   2.6444423237025737e-08
   2.9225607506844726e-08
   3.2299291479658129e-08
   3.5696237617766722e-08
   3.9450443699873716e-08
   4.3599483082281089e-08
   4.8184880745668262e-08
   5.3252528891055793e-08
   5.8853146244378082e-08
   6.5042785666539686e-08
   7.1883395149287240e-08
   7.9443437811532343e-08
   8.7798577101256825e-08
   9.7032434060731539e-08
   1.0723742423401342e-07
   1.1851568259277232e-07
   1.3098008573741623e-07
   1.4475538160404734e-07
   1.5997943798373573e-07
   1.7680462234971138e-07
   1.9539932680224871e-07
   2.1594965339340473e-07
   2.3866127669890702e-07
   2.6376150227843728e-07
   2.9150154162607256e-07
   3.2215902637935327e-07
   3.5604078695002664e-07
   3.9348592338593700e-07
   4.3486919919827997e-07
   4.8060479212078480e-07
   5.3115043933968360e-07
   5.8701201868132178e-07
   6.4874861160747570e-07
   7.1697809869053571e-07
   7.9238334356995170e-07
   8.7571902728105488e-07
   9.6781920135651654e-07
   1.0696056352944216e-06
   1.1820970419372223e-06
   1.3064192730922673e-06
   1.4438165874351013e-06
   1.5956641034684996e-06
   1.7634815621706371e-06
   1.9489485370736003e-06
   2.1539212439998211e-06
   2.3804511186939235e-06
   2.6308053482811660e-06
   2.9074895620382204e-06
   3.2132729085731429e-06
   3.5512157703953872e-06
   3.9247003932525885e-06
   4.3374647367828189e-06
   4.7936398852710157e-06
   5.2977913929290109e-06
   5.8549649774966190e-06
   6.4707370194807025e-06
   7.1512703724455683e-06
   7.9033760429228480e-06
   8.7345813572541237e-06
   9.6532052976029776e-06
   1.0668441761124589e-05
   1.1790451575578641e-05
   1.3030464192308714e-05
   1.4400890074365673e-05
   1.5915444904593194e-05
   1.7589286856791647e-05
   1.9439168303816350e-05
   2.1483603480955747e-05
   2.3743053782621043e-05
   2.6240132546858776e-05
   2.8999831377238596e-05
   3.2049770267221755e-05
   3.5420474030339066e-05
   3.9145677802784465e-05
   4.3262664675996812e-05
   4.7812638838370288e-05
   5.2841137960621061e-05
   5.8398488952101537e-05
   6.4540311649424626e-05
   7.1328075478483034e-05
   7.8829714661124184e-05
   8.7120308123675967e-05
   9.6282830912076270e-05
   1.0640898463402168e-04
   1.1760011523947924e-04
   1.2996822732501724e-04
   1.4363710511345378e-04
   1.5874355132796403e-04
   1.7543875635971472e-04
   1.9388981143211579e-04
   2.1428138090594562e-04
   2.3681755046234149e-04
   2.6172386966089197e-04
   2.8924960931543914e-04
   3.1967025628016629e-04
   3.5329027061462893e-04
   3.9044613272236350e-04
   4.3150971095986065e-04
   4.7689198342006658e-04
   5.2704715113927156e-04
   5.8247718389374341e-04
   6.4373684408196633e-04
   7.1143923897318674e-04
   7.8626195689103691e-04
   8.6895384874522254e-04
   9.6034252278312515e-04
   1.0613426275713101e-03
   1.1729650061058051e-03
   1.2963268126685603e-03
   1.4326626936829910e-03
   1.5833371444703617e-03
   1.7498581655775839e-03
   1.9338923553535471e-03
   2.1372815898255564e-03
   2.3620614568136901e-03
   2.6104816287778878e-03
   2.8850283782960702e-03
   3.1884494615157647e-03
   3.5237816186211822e-03
   3.8943809665496639e-03
   4.3039565881380203e-03
   4.7566076538702283e-03
   5.2568644477534125e-03
   5.8097337079228714e-03
   6.4207487357601564e-03
   7.0960247750331065e-03
   7.8423202153108801e-03
   8.6671042321983371e-03
   9.5786315413559676e-03
   1.0586025014468731e-02
   1.1699366984012178e-02
   1.2929800150624660e-02
   1.4289639103000504e-02
   1.5792493566432742e-02
   1.7453404613518231e-02
   1.9288995200267688e-02
   2.1317636534236600e-02
   2.3559631939745231e-02
   2.6037420060372587e-02
   2.8775799432443259e-02
   3.1802176677114019e-02
   3.5146840795050052e-02
   3.8843266308924096e-02
   4.2928448287690518e-02
   4.7443272605669898e-02
   5.2432925142121424e-02
   5.7947344016710048e-02
   6.4041719386992838e-02
   7.0777045810065886e-02
   7.8220732696592687e-02
   8.6447278966843177e-02
   9.5539018660927705e-02
   1.0558694496554391e-01
   1.1669162090437306e-01
   1.2896418580662142e-01
   1.4252746762678220e-01
   1.5751721224808804e-01
   1.7408344207293611e-01
   1.9239195749751564e-01
   2.1262599629790035e-01
   2.3498806753529980e-01
   2.5970197833480957e-01
   2.8701507382234348e-01
   3.1720071263778915e-01
   3.5056100280015512e-01
   3.8742982530616715e-01
   4.2817617572350458e-01
   4.7320785722246539e-01
   5.2297556200716211e-01
   5.7797738199458315e-01
   6.3876379388591276e-01
   7.0594316852237804e-01
   7.8018785966510817e-01
   8.6224093313756223e-01
   9.5292360367804285e-01
   1.0531434539328173e+00
   1.1639035178482904e+00
   1.2863123193718711e+00
   1.4215949669322265e+00
   1.5711054147362089e+00
   1.7363400135976372e+00
   1.9189524869191834e+00
   2.1207704817120212e+00
   2.3438138603014083e+00
   2.5903149157877352e+00
   2.8627407135861755e+00
   3.1638177826465683e+00
   3.4965594034715681e+00
   3.8642957660407120e+00
   4.2707072994710522e+00
   4.7198615069887930e+00
   5.2162536748687147e+00
   5.7648518627701284e+00
   6.3711466257477705e+00
   7.0412059655722290e+00
   7.7817360613311877e+00
   8.6001483871237632e+00
   9.5046338885843706e+00
   1.0504244960619703e+01
   1.1608986046819572e+01
   1.2829913767290970e+01
   1.4179247577028352e+01
   1.5670492062326328e+01
   1.7318572099218340e+01
   1.9139982226652432e+01
   2.1152951729381048e+01
   2.3377627082769912e+01
   2.5836273585494951e+01
   2.8553498198135060e+01
   3.1556495817904278e+01
   3.4875321454323611e+01
   3.8543191029858157e+01
   4.2596813816033411e+01
   4.7076759832163077e+01
   5.2027865883738443e+01
   5.7499684304247886e+01
   6.3546978891585546e+01
   7.0230273002547406e+01
   7.7616455290928698e+01
   8.5779449151653139e+01
   9.4800952570955843e+01
   1.0477125578728921e+02
   1.1579014494637693e+02
   1.2796790079449971e+02
   1.4142640240527066e+02
   1.5630034698636896e+02
   1.7273859797446769e+02
   1.9090567491054267e+02
   2.1098340000673559e+02
   2.3317271788416559e+02
   2.5769570669423729e+02
   2.8479780075142304e+02
   3.1475024692237560e+02
   3.4785281935573863e+02
   3.8443681972258412e+02
   4.2486839299489054e+02
   4.6955219194748827e+02
   5.1893542705903837e+02
   5.7351234234481581e+02
   6.3382916191693528e+02
   7.0048955677885772e+02
   7.7416068656769369e+02
   8.5557987671209173e+02
   9.4556199783295187e+02
   1.0450076212424869e+03
   1.1549120321646080e+03
   1.2763751908839718e+03
   1.4106127415182191e+03
   1.5589681785928965e+03
   1.7229262931862318e+03
   1.9041280332173003e+03
   2.1043869266043412e+03
   2.3257072316617105e+03
   2.5703039963907459e+03
   2.8406252274246667e+03
   3.1393763905017645e+03
   3.4695474876758481e+03
   3.8344429822617740e+03
   4.2377148710149695e+03
   4.6833992345424385e+03
   5.1759566317540530e+03
   5.7203167426353639e+03
   6.3219277061418234e+03
   6.9868106470046323e+03
   7.7216199371708199e+03
   8.5337097949943000e+03
   9.4312078887249972e+03
   1.0423096680944496e+04
   1.1519303328070666e+04
   1.2730799034675721e+04
   1.4069708856989137e+04
   1.5549433054535755e+04
   1.7184781204437102e+04
   1.8992120420636886e+04
   2.0989539161478522e+04
   2.3197028265075980e+04
   2.5636681024340771e+04
   2.8332914304083228e+04
   3.1312712913202311e+04
   3.4605899677722984e+04
   3.8245433917662871e+04
   4.2267741314984989e+04
   4.6713078474065944e+04
   5.1625935823323234e+04
   5.7055482890376610e+04
   6.3056060407206925e+04
   6.9687724170466376e+04
   7.7016846100076829e+04
   8.5116778511712779e+04
   9.4068588251431182e+04
   1.0396186803991429e+05
   1.1489563314653141e+05
   1.2697931236743495e+05
   1.4033384322573253e+05
   1.5509288235486683e+05
   1.7140414317912661e+05
   1.8943087427924512e+05
   2.0935349323906592e+05
   2.3137139232536239e+05
   2.5570493407266162e+05
   2.8259765674555639e+05
   3.1231871175151330e+05
   3.4516555739862355e+05
   3.8146693595832947e+05
   4.2158616382857127e+05
   4.6592476772641251e+05
   5.1492650330238225e+05
   5.6908179639617680e+05
   6.2893265138330159e+05
   6.9507807573703467e+05
   7.6818007509655319e+05
   8.4897027884187771e+05
   9.3825726248661662e+05
   1.0369346401734781e+06
   1.1459900082649642e+06
   1.2665148295397097e+06
   1.3997153569188234e+06
   1.5469247060505589e+06
   1.7096161975797976e+06
   1.8894181026362628e+06
   2.0881299391192668e+06
   2.3077404818776865e+06
   2.5504476670371005e+06
   2.8186805896832864e+06
   3.1151238150622859e+06
   3.4427442466117009e+06
   3.8048208197275074e+06
   4.2049773184515880e+06
   4.6472186435204167e+06
   5.1359708947577253e+06
   5.6761256689692009e+06
   6.2730890166874416e+06
   6.9328355477427216e+06
   7.6619682271663100e+06
   8.4677844598838333e+06
   9.3583491255965196e+06
   1.0342575294807941e+07
   1.1430313433829404e+07
   1.2632449991557652e+07
   1.3961016354714479e+07
   1.5429309262008933e+07
   1.7052023882367507e+07
   1.8845400889123969e+07
   2.0827389002136763e+07
   2.3017824624610133e+07
   2.5438630372484632e+07
   2.8114034483345896e+07
   3.1070813300769802e+07
   3.4338559260968812e+07
   3.7949977063839935e+07
   4.1941210992593758e+07
   4.6352206657889292e+07
   5.1227110786931656e+07
   5.6614713058756173e+07
   6.2568934407734923e+07
   6.9149366682411388e+07
   7.6421869060750201e+07
   8.4459227190926239e+07
   9.3341881654555663e+07
   1.0315873304307374e+08
   1.1400803170473446e+08
   1.2599836106711893e+08
   1.3924972437657478e+08
   1.5389474573104006e+08
   1.7007999742659190e+08
   1.8796746690225038e+08
   2.0773617796471399e+08
   2.2958398251878911e+08
   2.5372954073575363e+08
   2.8041450947784531e+08
   3.0990596088136274e+08
   3.4249905530437142e+08
   3.7851999539077419e+08
   4.1832929081601185e+08
   4.6232536638906646e+08
   5.1094854962186480e+08
   5.6468547767501700e+08
   6.2407396778608418e+08
   6.8970839992525887e+08
   7.6224566554988432e+08
   8.4241174199494874e+08
   9.3100895829826319e+08
   1.0289240251791439e+09
   1.1371369095373254e+09
   1.2567306422910707e+09
   1.3889021577146211e+09
   1.5349742727587159e+09
   1.6964089262472496e+09
   1.8748218104523966e+09
   2.0719985414859231e+09
   2.2899125303454008e+09
   2.5307447334747562e+09
   2.7969054805094066e+09
   3.0910585976653914e+09
   3.4161480682074847e+09
   3.7754274968232164e+09
   4.1724926727921586e+09
   4.6113175578536234e+09
   5.0962940589514427e+09
   5.6322759839148350e+09
   6.2246276199985800e+09
   6.8792774214728651e+09
   7.6027773435862408e+09
   8.4023684167359400e+09
   9.2860532171338844e+09
   1.0262675959279177e+10
   1.1342011011829447e+10
   1.2534860722767656e+10
   1.3853163532931507e+10
   1.5310113459941998e+10
   1.6920292148366428e+10
   1.8699814807718300e+10
   2.0666491498890625e+10
   2.2840005383231522e+10
   2.5242109718238716e+10
   2.7896845571472111e+10
   3.0830782431638401e+10
   3.4073284124964363e+10
   3.7656802698239258e+10
   4.1617203209806610e+10
   4.5994122679122765e+10
   5.0831366787370079e+10
   5.6177348299437775e+10
   6.2085571595145073e+10
   6.8615168159057838e+10
   7.5831488388260895e+10
   8.3806755641097107e+10
   9.2620789072812759e+10
   1.0236180249249139e+11
   1.1312728723650484e+11
   1.2502498789457556e+11
   1.3817398065384482e+11
   1.5270586505337646e+11
   1.6876608107657605e+11
   1.8651536476342874e+11
   2.0613135691081287e+11
   2.2781038096130206e+11
   2.5176940787416525e+11
   2.7824822764365344e+11
   3.0751184919785828e+11
   3.3985315269713715e+11
   3.7559582077719836e+11
   4.1509757807371277e+11
   4.5875377145070300e+11
   5.0700132676483929e+11
   5.6032312176626892e+11
   6.1925281890144031e+11
   6.8438020638623755e+11
   7.5635710100467944e+11
   8.3590387171037695e+11
   9.2381664932114575e+11
   1.0209752944638193e+12
   1.1283522035151340e+12
   1.2470220406715007e+12
   1.3781724935494902e+12
   1.5231161599626948e+12
   1.6833036848418264e+12
   1.8603382787767620e+12
   2.0559917634869844e+12
   2.2722223048088804e+12
   2.5111940106775947e+12
   2.7752985902466255e+12
   3.0671792909169141e+12
   3.3897573528452603e+12
   3.7462612456976733e+12
   4.1402589802589175e+12
   4.5756938182836924e+12
   5.0569237379856543e+12
   5.5887650501481416e+12
   6.1765406013813154e+12
   6.8261330469601016e+12
   7.5440437264154141e+12
   8.3374577311253535e+12
   9.2143158151247129e+12
   1.0183393868840340e+13
   1.1254390751152201e+13
   1.2438025358832957e+13
   1.3746143904869607e+13
   1.5191838479344713e+13
   1.6789578079474348e+13
   1.8555353420195434e+13
   2.0506836974615496e+13
   2.2663559846063445e+13
   2.5047107241936324e+13
   2.7681334505709973e+13
   3.0592605869234598e+13
   3.3810058314828449e+13
   3.7365893187990141e+13
   4.1295698479287656e+13
   4.5638805000929469e+13
   5.0438680022752680e+13
   5.5743362307269414e+13
   6.1605942897748391e+13
   6.8085096471220516e+13
   7.5245668574367812e+13
   8.3159324619549984e+13
   9.1905267136338875e+13
   1.0157102845705528e+14
   1.1225334676977153e+14
   1.2405913430661245e+14
   1.3710654735730897e+14
   1.5152616881705944e+14
   1.6746231510403516e+14
   1.8507448052659994e+14
   2.0453893355595603e+14
   2.2605048098024984e+14
   2.4982441759638447e+14
   2.7609868095271022e+14
   3.0513623270798212e+14
   3.3722769044002506e+14
   3.7269423624413281e+14
   4.1189083123143062e+14
   4.5520976809898188e+14
   5.0308459732695450e+14
   5.5599446629754788e+14
   6.1446891476304075e+14
   6.7909317465761662e+14
   7.5051402729526438e+14
   8.2944627657455900e+14
   9.1667990297633300e+14
   1.0130879699538496e+15
   1.1196353618452902e+15
   1.2373884407605195e+15
   1.3675257190914975e+15
   1.5113496544604105e+15
   1.6702996851533248e+15
   1.8459666365023652e+15
   2.0401086424003345e+15
   2.2546687412956410e+15
   2.4917943227741685e+15
   2.7538586193560145e+15
   3.0434844586042220e+15
   3.3635705132645935e+15
   3.7173203121568085e+15
   4.1082743021675935e+15
   4.5403452822331500e+15
   5.0178575639460460e+15
   5.5455902507190850e+15
   6.1288250686585730e+15
   6.7733992278544400e+15
   7.4857638431407750e+15
   8.2730484990213790e+15
   9.1431326049478160e+15
   1.0104724255097566e+16
   1.1167447381907442e+16
   1.2341938075624136e+16
   1.3639951033870320e+16
   1.5074477206609342e+16
   1.6659873813938872e+16
   1.8412008037975264e+16
   2.0348415826945328e+16
   2.2488477400850208e+16
   2.4853611215221080e+16
   2.7467488324221096e+16
   3.0356269288511564e+16
   3.3548865998935916e+16
   3.7077231036440888e+16
   4.0976677464246272e+16
   4.5286232252850760e+16
   5.0049026875070080e+16
   5.5312728980313968e+16
   6.1130019468443072e+16
   6.7559119737921448e+16
   7.4664374385141264e+16
   8.2516895186770448e+16
   9.1195272810315088e+16
   1.0078636337593507e+17
   1.1138615774168800e+17
   1.2310074221230024e+17
   1.3604736028656150e+17
   1.5035558606966758e+17
   1.6616862109441658e+17
   1.8364472753028080e+17
   2.0295881212439261e+17
   2.2430417672705789e+17
   2.4789445292164490e+17
   2.7396574012127472e+17
   3.0277896853110349e+17
   3.3462251062551731e+17
   3.6981506727678112e+17
   4.0870885742048762e+17
   4.5169314318104928e+17
   4.9919812573787520e+17
   5.5169925092337018e+17
   6.0972196764462810e+17
   6.7384698675270400e+17
   7.4471609299199475e+17
   8.2303856819767232e+17
   9.0959829002668813e+17
   1.0052615772688342e+18
   1.1109858602563712e+18
   1.2278292631485970e+18
   1.3569611939940810e+18
   1.4996740485594657e+18
   1.6573961450606881e+18
   1.8317060192517601e+18
   2.0243482229411579e+18
   2.2372507840526853e+18
   2.4725445029769687e+18
   2.7325842783379528e+18
   3.0199726756098365e+18
   3.3375859744670935e+18
   3.6886029555582029e+18
   4.0765367148108068e+18
   4.5052698236765440e+18
   4.9790931872111176e+18
   5.5027489888943135e+18
   6.0814781519961702e+18
   6.7210727924986010e+18
   7.4279341885389363e+18
   8.2091368465530675e+18
   9.0724993053136814e+18
   1.0026662386494198e+19
   1.1081175674916358e+19
   1.2246593094004847e+19
   1.3534578533000223e+19
   1.4958022583082809e+19
   1.6531171550741899e+19
   1.8269770039599454e+19
   2.0191218527695090e+19
   2.2314747517318812e+19
   2.4661610000341512e+19
   2.7255294165301002e+19
   3.0121758475087553e+19
   3.3289691467965432e+19
   3.6790798882106413e+19
   4.0660120977274061e+19
   4.4936383229520880e+19
   4.9662383908768727e+19
   5.4885422418279211e+19
   6.0657772682979369e+19
   6.7037206324472250e+19
   7.4087570858843619e+19
   8.1879428704062800e+19
   9.0490763392378634e+19
   1.0000776005572131e+20
   1.1052566799547061e+20
   1.2214975396947848e+20
   1.3499635573716302e+20
   1.4919404640690720e+20
   1.6488492123894242e+20
   1.8222601978247286e+20
   2.0139089758026668e+20
   2.2257136317086207e+20
   2.4597939777289005e+20
   2.7184927686435983e+20
   3.0043991489038549e+20
   3.3203745656597683e+20
   3.6695814070852361e+20
   4.0555146526217175e+20
   4.4820368519071852e+20
   4.9534167824711496e+20
   5.4743721730949612e+20
   6.0501169204271369e+20
   6.6864132714134700e+20
   7.3896294938012195e+20
   8.1668036119031775e+20
   9.0257138455105503e+20
   9.9749564569309793e+20
   1.1024031785271021e+21
   1.2183439329023096e+21
   1.3464782828575407e+21
   1.4880886400345899e+21
   1.6445922884849697e+21
   1.8175555693250643e+21
   2.0087095572044880e+21
   2.2199673854830119e+21
   2.4534433935122555e+21
   2.7114742876545719e+21
   2.9966425278257163e+21
   3.3118021736216768e+21
   3.6601074487063940e+21
   4.0450443093423623e+21
   4.4704653330125727e+21
   4.9406282763108614e+21
];
%
% Get the points at which to evaluate F.
%
Y=YBASE/B;

