%
%  z1=hankel1(funname,B)
%
%    funname       The name of the function to be transformed.
%    B             The transform argument.
%    z1            The value of the transform of order 1.
%
%  Based on Walt Anderson's Fortran code, which was published in:
%
%  Anderson, W. L., 1979, Computer Program Numerical Integration of Related
%  Hankel Transforms of Orders 0 and 1 by Adaptive Digital Filtering.
%  Geophysic, 44(7):1287-1305.
%
function z1=hankel1(funname,B)
%
%  Points at which the function will be evaluated.  Note that these
%  are scaled by B before being used.
%
YBASE=[
   8.9170998013274418e-14
   9.8549193740052245e-14
   1.0891370292130841e-13
   1.2036825704856076e-13
   1.3302749714952345e-13
   1.4701812115404443e-13
   1.6248015192957209e-13
   1.7956833867707590e-13
   1.9845370571306282e-13
   2.1932526413842005e-13
   2.4239190352504162e-13
   2.6788448255287407e-13
   2.9605813952117967e-13
   3.2719484585839035e-13
   3.6160622818693727e-13
   3.9963668718722961e-13
   4.4166684447542096e-13
   4.8811735199247527e-13
   5.3945310203017795e-13
   5.9618788002944785e-13
   6.5888950671771899e-13
   7.2818552104963217e-13
   8.0476946082781583e-13
   8.8940780386232124e-13
   9.8294763913816720e-13
   1.0863251447666186e-12
   1.2005749575703847e-12
   1.3268405280766938e-12
   1.4663855645544968e-12
   1.6206066806315702e-12
   1.7910473730731204e-12
   1.9794134696161976e-12
   2.1875902014670364e-12
   2.4176610713286156e-12
   2.6719287057960000e-12
   2.9529379008172425e-12
   3.2635010908665675e-12
   3.6067264967338821e-12
   3.9860492336431492e-12
   4.4052656910401313e-12
   4.8685715281339743e-12
   5.3806036654647833e-12
   5.9464866927629101e-12
   6.5718841575654077e-12
   7.2630552479033658e-12
   8.0269174363595134e-12
   8.8711157124588670e-12
   9.8040990962934688e-12
   1.0835205199155280e-11
   1.1974753677488471e-11
   1.3234149515479672e-11
   1.4625997169973058e-11
   1.6164226720110948e-11
   1.7864233284247930e-11
   1.9743031099469828e-11
   2.1819423805797136e-11
   2.4114192639334462e-11
   2.6650304417866294e-11
   2.9453141400488783e-11
   3.2550755321790057e-11
   3.5974148143038491e-11
   3.9757582330231206e-11
   4.3938923764369768e-11
   4.8560020715924429e-11
   5.3667122676390673e-11
   5.9311343238745088e-11
   6.5549171659463761e-11
   7.2443038221987792e-11
   8.0061939059983487e-11
   8.8482126693838504e-11
   9.7787873191515278e-11
   1.0807231359173195e-10
   1.1943837803073370e-10
   1.3199982190169224e-10
   1.4588236435691521e-10
   1.6122494654737812e-10
   1.7818112219246310e-10
   1.9692059439719362e-10
   2.1763091409794871e-10
   2.4051935713527238e-10
   2.6581499874015355e-10
   2.9377100619593265e-10
   3.2466717262156566e-10
   3.5881271723520049e-10
   3.9654938012404428e-10
   4.3825484249401899e-10
   4.8434650663021337e-10
   5.3528567339924565e-10
   5.9158215910338558e-10
   6.5379939789346253e-10
   7.2256008080722362e-10
   7.9855238787053352e-10
   8.8253687563437822e-10
   9.7535408908045947e-10
   1.0779329740778886e-09
   1.1913001745856734e-09
   1.3165903076505279e-09
   1.4550573190356333e-09
   1.6080870331313015e-09
   1.7772110227512649e-09
   1.9641219376281762e-09
   2.1706904450210516e-09
   2.3989839519819520e-09
   2.6512872966606394e-09
   2.9301256157327411e-09
   3.2382896168163261e-09
   3.5788635088117363e-09
   3.9552558697009004e-09
   4.3712337607414382e-09
   4.8309604284818817e-09
   5.3390369719324459e-09
   5.9005483919104070e-09
   6.5211144834374116e-09
   7.2069460805369272e-09
   7.9649072163486862e-09
   8.8025838206794284e-09
   9.7283596425381269e-09
   1.0751500157513941e-08
   1.1882245299770154e-08
   1.3131911946747030e-08
   1.4513007182274982e-08
   1.6039353471673310e-08
   1.7726227001629019e-08
   1.9590510569407677e-08
   2.1650862551562963e-08
   2.3927903643240499e-08
   2.6444423237025737e-08
   2.9225607506844726e-08
   3.2299291479658129e-08
   3.5696237617766722e-08
   3.9450443699873716e-08
   4.3599483082281089e-08
   4.8184880745668262e-08
   5.3252528891055793e-08
   5.8853146244378082e-08
   6.5042785666539686e-08
   7.1883395149287240e-08
   7.9443437811532343e-08
   8.7798577101256825e-08
   9.7032434060731539e-08
   1.0723742423401342e-07
   1.1851568259277232e-07
   1.3098008573741623e-07
   1.4475538160404734e-07
   1.5997943798373573e-07
   1.7680462234971138e-07
   1.9539932680224871e-07
   2.1594965339340473e-07
   2.3866127669890702e-07
   2.6376150227843728e-07
   2.9150154162607256e-07
   3.2215902637935327e-07
   3.5604078695002664e-07
   3.9348592338593700e-07
   4.3486919919827997e-07
   4.8060479212078480e-07
   5.3115043933968360e-07
   5.8701201868132178e-07
   6.4874861160747570e-07
   7.1697809869053571e-07
   7.9238334356995170e-07
   8.7571902728105488e-07
   9.6781920135651654e-07
   1.0696056352944216e-06
   1.1820970419372223e-06
   1.3064192730922673e-06
   1.4438165874351013e-06
   1.5956641034684996e-06
   1.7634815621706371e-06
   1.9489485370736003e-06
   2.1539212439998211e-06
   2.3804511186939235e-06
   2.6308053482811660e-06
   2.9074895620382204e-06
   3.2132729085731429e-06
   3.5512157703953872e-06
   3.9247003932525885e-06
   4.3374647367828189e-06
   4.7936398852710157e-06
   5.2977913929290109e-06
   5.8549649774966190e-06
   6.4707370194807025e-06
   7.1512703724455683e-06
   7.9033760429228480e-06
   8.7345813572541237e-06
   9.6532052976029776e-06
   1.0668441761124589e-05
   1.1790451575578641e-05
   1.3030464192308714e-05
   1.4400890074365673e-05
   1.5915444904593194e-05
   1.7589286856791647e-05
   1.9439168303816350e-05
   2.1483603480955747e-05
   2.3743053782621043e-05
   2.6240132546858776e-05
   2.8999831377238596e-05
   3.2049770267221755e-05
   3.5420474030339066e-05
   3.9145677802784465e-05
   4.3262664675996812e-05
   4.7812638838370288e-05
   5.2841137960621061e-05
   5.8398488952101537e-05
   6.4540311649424626e-05
   7.1328075478483034e-05
   7.8829714661124184e-05
   8.7120308123675967e-05
   9.6282830912076270e-05
   1.0640898463402168e-04
   1.1760011523947924e-04
   1.2996822732501724e-04
   1.4363710511345378e-04
   1.5874355132796403e-04
   1.7543875635971472e-04
   1.9388981143211579e-04
   2.1428138090594562e-04
   2.3681755046234149e-04
   2.6172386966089197e-04
   2.8924960931543914e-04
   3.1967025628016629e-04
   3.5329027061462893e-04
   3.9044613272236350e-04
   4.3150971095986065e-04
   4.7689198342006658e-04
   5.2704715113927156e-04
   5.8247718389374341e-04
   6.4373684408196633e-04
   7.1143923897318674e-04
   7.8626195689103691e-04
   8.6895384874522254e-04
   9.6034252278312515e-04
   1.0613426275713101e-03
   1.1729650061058051e-03
   1.2963268126685603e-03
   1.4326626936829910e-03
   1.5833371444703617e-03
   1.7498581655775839e-03
   1.9338923553535471e-03
   2.1372815898255564e-03
   2.3620614568136901e-03
   2.6104816287778878e-03
   2.8850283782960702e-03
   3.1884494615157647e-03
   3.5237816186211822e-03
   3.8943809665496639e-03
   4.3039565881380203e-03
   4.7566076538702283e-03
   5.2568644477534125e-03
   5.8097337079228714e-03
   6.4207487357601564e-03
   7.0960247750331065e-03
   7.8423202153108801e-03
   8.6671042321983371e-03
   9.5786315413559676e-03
   1.0586025014468731e-02
   1.1699366984012178e-02
   1.2929800150624660e-02
   1.4289639103000504e-02
   1.5792493566432742e-02
   1.7453404613518231e-02
   1.9288995200267688e-02
   2.1317636534236600e-02
   2.3559631939745231e-02
   2.6037420060372587e-02
   2.8775799432443259e-02
   3.1802176677114019e-02
   3.5146840795050052e-02
   3.8843266308924096e-02
   4.2928448287690518e-02
   4.7443272605669898e-02
   5.2432925142121424e-02
   5.7947344016710048e-02
   6.4041719386992838e-02
   7.0777045810065886e-02
   7.8220732696592687e-02
   8.6447278966843177e-02
   9.5539018660927705e-02
   1.0558694496554391e-01
   1.1669162090437306e-01
   1.2896418580662142e-01
   1.4252746762678220e-01
   1.5751721224808804e-01
   1.7408344207293611e-01
   1.9239195749751564e-01
   2.1262599629790035e-01
   2.3498806753529980e-01
   2.5970197833480957e-01
   2.8701507382234348e-01
   3.1720071263778915e-01
   3.5056100280015512e-01
   3.8742982530616715e-01
   4.2817617572350458e-01
   4.7320785722246539e-01
   5.2297556200716211e-01
   5.7797738199458315e-01
   6.3876379388591276e-01
   7.0594316852237804e-01
   7.8018785966510817e-01
   8.6224093313756223e-01
   9.5292360367804285e-01
   1.0531434539328173e+00
   1.1639035178482904e+00
   1.2863123193718711e+00
   1.4215949669322265e+00
   1.5711054147362089e+00
   1.7363400135976372e+00
   1.9189524869191834e+00
   2.1207704817120212e+00
   2.3438138603014083e+00
   2.5903149157877352e+00
   2.8627407135861755e+00
   3.1638177826465683e+00
   3.4965594034715681e+00
   3.8642957660407120e+00
   4.2707072994710522e+00
   4.7198615069887930e+00
   5.2162536748687147e+00
   5.7648518627701284e+00
   6.3711466257477705e+00
   7.0412059655722290e+00
   7.7817360613311877e+00
   8.6001483871237632e+00
   9.5046338885843706e+00
   1.0504244960619703e+01
   1.1608986046819572e+01
   1.2829913767290970e+01
   1.4179247577028352e+01
   1.5670492062326328e+01
   1.7318572099218340e+01
   1.9139982226652432e+01
   2.1152951729381048e+01
   2.3377627082769912e+01
   2.5836273585494951e+01
   2.8553498198135060e+01
   3.1556495817904278e+01
   3.4875321454323611e+01
   3.8543191029858157e+01
   4.2596813816033411e+01
   4.7076759832163077e+01
   5.2027865883738443e+01
   5.7499684304247886e+01
   6.3546978891585546e+01
   7.0230273002547406e+01
   7.7616455290928698e+01
   8.5779449151653139e+01
   9.4800952570955843e+01
   1.0477125578728921e+02
   1.1579014494637693e+02
   1.2796790079449971e+02
   1.4142640240527066e+02
   1.5630034698636896e+02
   1.7273859797446769e+02
   1.9090567491054267e+02
   2.1098340000673559e+02
   2.3317271788416559e+02
   2.5769570669423729e+02
   2.8479780075142304e+02
   3.1475024692237560e+02
   3.4785281935573863e+02
   3.8443681972258412e+02
   4.2486839299489054e+02
   4.6955219194748827e+02
   5.1893542705903837e+02
   5.7351234234481581e+02
   6.3382916191693528e+02
   7.0048955677885772e+02
   7.7416068656769369e+02
   8.5557987671209173e+02
   9.4556199783295187e+02
   1.0450076212424869e+03
   1.1549120321646080e+03
   1.2763751908839718e+03
   1.4106127415182191e+03
   1.5589681785928965e+03
   1.7229262931862318e+03
   1.9041280332173003e+03
   2.1043869266043412e+03
   2.3257072316617105e+03
   2.5703039963907459e+03
   2.8406252274246667e+03
   3.1393763905017645e+03
   3.4695474876758481e+03
   3.8344429822617740e+03
   4.2377148710149695e+03
   4.6833992345424385e+03
   5.1759566317540530e+03
   5.7203167426353639e+03
   6.3219277061418234e+03
   6.9868106470046323e+03
   7.7216199371708199e+03
   8.5337097949943000e+03
   9.4312078887249972e+03
   1.0423096680944496e+04
   1.1519303328070666e+04
   1.2730799034675721e+04
   1.4069708856989137e+04
   1.5549433054535755e+04
   1.7184781204437102e+04
   1.8992120420636886e+04
   2.0989539161478522e+04
   2.3197028265075980e+04
   2.5636681024340771e+04
   2.8332914304083228e+04
   3.1312712913202311e+04
   3.4605899677722984e+04
   3.8245433917662871e+04
   4.2267741314984989e+04
   4.6713078474065944e+04
   5.1625935823323234e+04
   5.7055482890376610e+04
   6.3056060407206925e+04
   6.9687724170466376e+04
   7.7016846100076829e+04
   8.5116778511712779e+04
   9.4068588251431182e+04
   1.0396186803991429e+05
   1.1489563314653141e+05
   1.2697931236743495e+05
   1.4033384322573253e+05
   1.5509288235486683e+05
   1.7140414317912661e+05
   1.8943087427924512e+05
   2.0935349323906592e+05
   2.3137139232536239e+05
   2.5570493407266162e+05
   2.8259765674555639e+05
   3.1231871175151330e+05
   3.4516555739862355e+05
   3.8146693595832947e+05
   4.2158616382857127e+05
   4.6592476772641251e+05
   5.1492650330238225e+05
   5.6908179639617680e+05
   6.2893265138330159e+05
   6.9507807573703467e+05
   7.6818007509655319e+05
   8.4897027884187771e+05
   9.3825726248661662e+05
   1.0369346401734781e+06
   1.1459900082649642e+06
   1.2665148295397097e+06
   1.3997153569188234e+06
   1.5469247060505589e+06
   1.7096161975797976e+06
   1.8894181026362628e+06
   2.0881299391192668e+06
   2.3077404818776865e+06
   2.5504476670371005e+06
   2.8186805896832864e+06
   3.1151238150622859e+06
   3.4427442466117009e+06
   3.8048208197275074e+06
   4.2049773184515880e+06
   4.6472186435204167e+06
   5.1359708947577253e+06
   5.6761256689692009e+06
   6.2730890166874416e+06
   6.9328355477427216e+06
   7.6619682271663100e+06
   8.4677844598838333e+06
   9.3583491255965196e+06
   1.0342575294807941e+07
   1.1430313433829404e+07
   1.2632449991557652e+07
   1.3961016354714479e+07
   1.5429309262008933e+07
   1.7052023882367507e+07
   1.8845400889123969e+07
   2.0827389002136763e+07
   2.3017824624610133e+07
   2.5438630372484632e+07
   2.8114034483345896e+07
   3.1070813300769802e+07
   3.4338559260968812e+07
   3.7949977063839935e+07
   4.1941210992593758e+07
   4.6352206657889292e+07
   5.1227110786931656e+07
   5.6614713058756173e+07
   6.2568934407734923e+07
   6.9149366682411388e+07
   7.6421869060750201e+07
   8.4459227190926239e+07
   9.3341881654555663e+07
   1.0315873304307374e+08
   1.1400803170473446e+08
   1.2599836106711893e+08
   1.3924972437657478e+08
   1.5389474573104006e+08
   1.7007999742659190e+08
   1.8796746690225038e+08
   2.0773617796471399e+08
   2.2958398251878911e+08
   2.5372954073575363e+08
   2.8041450947784531e+08
   3.0990596088136274e+08
   3.4249905530437142e+08
   3.7851999539077419e+08
   4.1832929081601185e+08
   4.6232536638906646e+08
   5.1094854962186480e+08
   5.6468547767501700e+08
   6.2407396778608418e+08
   6.8970839992525887e+08
   7.6224566554988432e+08
   8.4241174199494874e+08
   9.3100895829826319e+08
   1.0289240251791439e+09
   1.1371369095373254e+09
   1.2567306422910707e+09
   1.3889021577146211e+09
   1.5349742727587159e+09
   1.6964089262472496e+09
   1.8748218104523966e+09
   2.0719985414859231e+09
   2.2899125303454008e+09
   2.5307447334747562e+09
   2.7969054805094066e+09
   3.0910585976653914e+09
   3.4161480682074847e+09
   3.7754274968232164e+09
   4.1724926727921586e+09
   4.6113175578536234e+09
   5.0962940589514427e+09
   5.6322759839148350e+09
   6.2246276199985800e+09
   6.8792774214728651e+09
   7.6027773435862408e+09
   8.4023684167359400e+09
   9.2860532171338844e+09
   1.0262675959279177e+10
   1.1342011011829447e+10
   1.2534860722767656e+10
   1.3853163532931507e+10
   1.5310113459941998e+10
   1.6920292148366428e+10
   1.8699814807718300e+10
   2.0666491498890625e+10
   2.2840005383231522e+10
   2.5242109718238716e+10
   2.7896845571472111e+10
   3.0830782431638401e+10
   3.4073284124964363e+10
   3.7656802698239258e+10
   4.1617203209806610e+10
   4.5994122679122765e+10
   5.0831366787370079e+10
   5.6177348299437775e+10
   6.2085571595145073e+10
   6.8615168159057838e+10
   7.5831488388260895e+10
   8.3806755641097107e+10
   9.2620789072812759e+10
   1.0236180249249139e+11
   1.1312728723650484e+11
   1.2502498789457556e+11
   1.3817398065384482e+11
   1.5270586505337646e+11
   1.6876608107657605e+11
   1.8651536476342874e+11
   2.0613135691081287e+11
   2.2781038096130206e+11
   2.5176940787416525e+11
   2.7824822764365344e+11
   3.0751184919785828e+11
   3.3985315269713715e+11
   3.7559582077719836e+11
   4.1509757807371277e+11
   4.5875377145070300e+11
   5.0700132676483929e+11
   5.6032312176626892e+11
   6.1925281890144031e+11
   6.8438020638623755e+11
   7.5635710100467944e+11
   8.3590387171037695e+11
   9.2381664932114575e+11
   1.0209752944638193e+12
   1.1283522035151340e+12
   1.2470220406715007e+12
   1.3781724935494902e+12
   1.5231161599626948e+12
   1.6833036848418264e+12
   1.8603382787767620e+12
   2.0559917634869844e+12
   2.2722223048088804e+12
   2.5111940106775947e+12
   2.7752985902466255e+12
   3.0671792909169141e+12
   3.3897573528452603e+12
   3.7462612456976733e+12
   4.1402589802589175e+12
   4.5756938182836924e+12
   5.0569237379856543e+12
   5.5887650501481416e+12
   6.1765406013813154e+12
   6.8261330469601016e+12
   7.5440437264154141e+12
   8.3374577311253535e+12
   9.2143158151247129e+12
   1.0183393868840340e+13
   1.1254390751152201e+13
   1.2438025358832957e+13
   1.3746143904869607e+13
   1.5191838479344713e+13
   1.6789578079474348e+13
   1.8555353420195434e+13
   2.0506836974615496e+13
   2.2663559846063445e+13
   2.5047107241936324e+13
   2.7681334505709973e+13
   3.0592605869234598e+13
   3.3810058314828449e+13
   3.7365893187990141e+13
   4.1295698479287656e+13
   4.5638805000929469e+13
   5.0438680022752680e+13
   5.5743362307269414e+13
   6.1605942897748391e+13
   6.8085096471220516e+13
   7.5245668574367812e+13
   8.3159324619549984e+13
   9.1905267136338875e+13
   1.0157102845705528e+14
   1.1225334676977153e+14
   1.2405913430661245e+14
   1.3710654735730897e+14
   1.5152616881705944e+14
   1.6746231510403516e+14
   1.8507448052659994e+14
   2.0453893355595603e+14
   2.2605048098024984e+14
   2.4982441759638447e+14
   2.7609868095271022e+14
   3.0513623270798212e+14
   3.3722769044002506e+14
   3.7269423624413281e+14
   4.1189083123143062e+14
   4.5520976809898188e+14
   5.0308459732695450e+14
   5.5599446629754788e+14
   6.1446891476304075e+14
   6.7909317465761662e+14
   7.5051402729526438e+14
   8.2944627657455900e+14
   9.1667990297633300e+14
   1.0130879699538496e+15
   1.1196353618452902e+15
   1.2373884407605195e+15
   1.3675257190914975e+15
   1.5113496544604105e+15
   1.6702996851533248e+15
   1.8459666365023652e+15
   2.0401086424003345e+15
   2.2546687412956410e+15
   2.4917943227741685e+15
   2.7538586193560145e+15
   3.0434844586042220e+15
   3.3635705132645935e+15
   3.7173203121568085e+15
   4.1082743021675935e+15
   4.5403452822331500e+15
   5.0178575639460460e+15
   5.5455902507190850e+15
   6.1288250686585730e+15
   6.7733992278544400e+15
   7.4857638431407750e+15
   8.2730484990213790e+15
   9.1431326049478160e+15
   1.0104724255097566e+16
   1.1167447381907442e+16
   1.2341938075624136e+16
   1.3639951033870320e+16
   1.5074477206609342e+16
   1.6659873813938872e+16
   1.8412008037975264e+16
   2.0348415826945328e+16
   2.2488477400850208e+16
   2.4853611215221080e+16
   2.7467488324221096e+16
   3.0356269288511564e+16
   3.3548865998935916e+16
   3.7077231036440888e+16
   4.0976677464246272e+16
   4.5286232252850760e+16
   5.0049026875070080e+16
   5.5312728980313968e+16
   6.1130019468443072e+16
   6.7559119737921448e+16
   7.4664374385141264e+16
   8.2516895186770448e+16
   9.1195272810315088e+16
   1.0078636337593507e+17
   1.1138615774168800e+17
   1.2310074221230024e+17
   1.3604736028656150e+17
   1.5035558606966758e+17
   1.6616862109441658e+17
   1.8364472753028080e+17
   2.0295881212439261e+17
   2.2430417672705789e+17
   2.4789445292164490e+17
   2.7396574012127472e+17
   3.0277896853110349e+17
   3.3462251062551731e+17
   3.6981506727678112e+17
   4.0870885742048762e+17
   4.5169314318104928e+17
   4.9919812573787520e+17
   5.5169925092337018e+17
   6.0972196764462810e+17
   6.7384698675270400e+17
   7.4471609299199475e+17
   8.2303856819767232e+17
   9.0959829002668813e+17
   1.0052615772688342e+18
   1.1109858602563712e+18
   1.2278292631485970e+18
   1.3569611939940810e+18
   1.4996740485594657e+18
   1.6573961450606881e+18
   1.8317060192517601e+18
   2.0243482229411579e+18
   2.2372507840526853e+18
   2.4725445029769687e+18
   2.7325842783379528e+18
   3.0199726756098365e+18
   3.3375859744670935e+18
   3.6886029555582029e+18
   4.0765367148108068e+18
   4.5052698236765440e+18
   4.9790931872111176e+18
   5.5027489888943135e+18
   6.0814781519961702e+18
   6.7210727924986010e+18
   7.4279341885389363e+18
   8.2091368465530675e+18
   9.0724993053136814e+18
   1.0026662386494198e+19
   1.1081175674916358e+19
   1.2246593094004847e+19
   1.3534578533000223e+19
   1.4958022583082809e+19
   1.6531171550741899e+19
   1.8269770039599454e+19
   2.0191218527695090e+19
   2.2314747517318812e+19
   2.4661610000341512e+19
   2.7255294165301002e+19
   3.0121758475087553e+19
   3.3289691467965432e+19
   3.6790798882106413e+19
   4.0660120977274061e+19
   4.4936383229520880e+19
   4.9662383908768727e+19
   5.4885422418279211e+19
   6.0657772682979369e+19
   6.7037206324472250e+19
   7.4087570858843619e+19
   8.1879428704062800e+19
   9.0490763392378634e+19
   1.0000776005572131e+20
   1.1052566799547061e+20
   1.2214975396947848e+20
   1.3499635573716302e+20
   1.4919404640690720e+20
   1.6488492123894242e+20
   1.8222601978247286e+20
   2.0139089758026668e+20
   2.2257136317086207e+20
   2.4597939777289005e+20
   2.7184927686435983e+20
   3.0043991489038549e+20
   3.3203745656597683e+20
   3.6695814070852361e+20
   4.0555146526217175e+20
   4.4820368519071852e+20
   4.9534167824711496e+20
   5.4743721730949612e+20
   6.0501169204271369e+20
   6.6864132714134700e+20
   7.3896294938012195e+20
   8.1668036119031775e+20
   9.0257138455105503e+20
   9.9749564569309793e+20
   1.1024031785271021e+21
   1.2183439329023096e+21
   1.3464782828575407e+21
   1.4880886400345899e+21
   1.6445922884849697e+21
   1.8175555693250643e+21
   2.0087095572044880e+21
   2.2199673854830119e+21
   2.4534433935122555e+21
   2.7114742876545719e+21
   2.9966425278257163e+21
   3.3118021736216768e+21
   3.6601074487063940e+21
   4.0450443093423623e+21
   4.4704653330125727e+21
   4.9406282763108614e+21
];
%
%  Next, setup the weights.
%
WT1=[
 -0.23779001100582381051E-28
  0.79721192934236443185E-27
  0.38325661863384939290E-27
  0.84934033213920264104E-27
  0.82321643716951481883E-27
  0.11003687170198490196E-26
  0.13254287328216880532E-26
  0.15922464286287840307E-26
  0.19986019650982509534E-26
  0.23685465814544270716E-26
  0.29798793392175001283E-26
  0.35431019643707156492E-26
  0.44257411307894436460E-26
  0.53180794470588352748E-26
  0.65556190066651513897E-26
  0.79947762199059232857E-26
  0.97071583223006191650E-26
  0.12004979935771289997E-25
  0.14406653509631588960E-25
  0.17970467112699249374E-25
  0.21453903977135419404E-25
  0.26816147371136119450E-25
  0.32037836290813990881E-25
  0.39922197526685471353E-25
  0.47937803770632117330E-25
  0.59351247450921383090E-25
  0.71773343544187673606E-25
  0.88252267695870270015E-25
  0.10736460080008319237E-24
  0.13139234241813519897E-24
  0.16038389953077929496E-24
  0.19586330559120450202E-24
  0.23934895950562681781E-24
  0.29216907136422889152E-24
  0.35704555610974980825E-24
  0.43591578004654766279E-24
  0.53258407091337795497E-24
  0.65037749121846816863E-24
  0.79446117848346841533E-24
  0.97029807615169898533E-24
  0.11851621862641970763E-23
  0.14475349036735769831E-23
  0.17680470446219830604E-23
  0.21594646724325061636E-23
  0.26376279226241200337E-23
  0.32215255903424431280E-23
  0.39348989123644471831E-23
  0.48059305631057603546E-23
  0.58701957447819091530E-23
  0.71696014006070338140E-23
  0.87572874338578454769E-23
  0.10695830329268070127E-22
  0.13064267975684400067E-22
  0.15956396898683340405E-22
  0.19489490174852410262E-22
  0.23804258576458750974E-22
  0.29074795736995329016E-22
  0.35511877512642321550E-22
  0.43374414815306912102E-22
  0.52977566601218580972E-22
  0.64706963771419739714E-22
  0.79033290084770208947E-22
  0.96531416601155305002E-22
  0.11790381653809730581E-21
  0.14400798270141680420E-21
  0.17589176532470089827E-21
  0.21483473765595870697E-21
  0.26239961572838840870E-21
  0.32049580752851479664E-21
  0.39145421602105668850E-21
  0.47812354861088417904E-21
  0.58398109523939098113E-21
  0.71327648305877594511E-21
  0.87119745891754148321E-21
  0.10640834348623049967E-20
  0.12996739243852600375E-20
  0.15874259111262610786E-20
  0.19388856933392509112E-20
  0.23681611511416871136E-20
  0.28924775863608318981E-20
  0.35328812735771197862E-20
  0.43150695199493149714E-20
  0.52704395186827729765E-20
  0.64373272953957132288E-20
  0.78625718444181387840E-20
  0.96033638142877597977E-20
  0.11729578932087649353E-19
  0.14326535217816349936E-19
  0.17498475666460750925E-19
  0.21372678938714691346E-19
  0.26104658300704859397E-19
  0.31884290164425472060E-19
  0.38943574121348422642E-19
  0.47565771349593827251E-19
  0.58096985951299433442E-19
  0.70959792070530976791E-19
  0.86670519080596190619E-19
  0.10585956951243269563E-18
  0.12929722209660508847E-18
  0.15792391867645680267E-18
  0.19288879140366910337E-18
  0.23559479941190520470E-18
  0.28775626657086499509E-18
  0.35146613570216158086E-18
  0.42928191135495900673E-18
  0.52432585404586203783E-18
  0.64041336717328802188E-18
  0.78220224663792857958E-18
  0.95538449298914256672E-18
  0.11669086110519650175E-17
  0.14252662063096260770E-17
  0.17408230557831051757E-17
  0.21262473650918901610E-17
  0.25970027813123101601E-17
  0.31719883922980728330E-17
  0.38742728138556379626E-17
  0.47320507187765319669E-17
  0.57797357502250896216E-17
  0.70593902823169582028E-17
  0.86223523498694457235E-17
  0.10531373010190409793E-16
  0.12863037889413019372E-16
  0.15710962731510451527E-16
  0.19189397138461720101E-16
  0.23438002820075089885E-16
  0.28627215837238828004E-16
  0.34965392409988710645E-16
  0.42706786428448497367E-16
  0.52162237447471309093E-16
  0.63711036879213345092E-16
  0.77816916463307065235E-16
  0.95045695365657204522E-16
  0.11608920160259351019E-15
  0.14179151105966549619E-15
  0.17318474398326101217E-15
  0.21152807068685210363E-15
  0.25836128767539467929E-15
  0.31556278833430849848E-15
  0.38542976466718232176E-15
  0.47076434267244616602E-15
  0.57499366556778888035E-15
  0.70229784368391582701E-15
  0.85778978838088164829E-15
  0.10477052216252109330E-14
  0.12796720504321799823E-14
  0.15629924515539289125E-14
  0.19090464627227088193E-14
  0.23317106244241540845E-14
  0.28479628092949809297E-14
  0.34785033119698000940E-14
  0.42486614900323137393E-14
  0.51893168582342936762E-14
  0.63382585119205047931E-14
  0.77415505884680514824E-14
  0.94555711726406619067E-14
  0.11549035630408280097E-13
  0.14106055531142479946E-13
  0.17229135422830471373E-13
  0.21043763493017538471E-13
  0.25702847898914450407E-13
  0.31393608430354023054E-13
  0.38344140375861572417E-13
  0.46833764078042948155E-13
  0.57202731000069601939E-13
  0.69867771751590042453E-13
  0.85336439559542886244E-13
  0.10423047667756279584E-12
  0.12730699655547051243E-12
  0.15549361393599358810E-12
  0.18991970329598081032E-12
  0.23196923668250597755E-12
  0.28332687489467591536E-12
  0.34605747293074408206E-12
  0.42267398347606569328E-12
  0.51625714279965715259E-12
  0.63055541477094275274E-12
  0.77016524760249830236E-12
  0.94067802567402927053E-12
  0.11489516827349049439E-11
  0.14033265286503660695E-11
  0.17140347264354340417E-11
  0.20935168852125301327E-11
  0.25570397012560628610E-11
  0.31231597365723921107E-11
  0.38146555551079558782E-11
  0.46592061049755500161E-11
  0.56907982819762827155E-11
  0.69507175913176593709E-11
  0.84896748701239594140E-11
  0.10369250352182410092E-10
  0.12665108932133729727E-10
  0.15469100894640800720E-10
  0.18894125922585180356E-10
  0.23077182209924898792E-10
  0.28186729422033271362E-10
  0.34427103160373659936E-10
  0.42049668170180476841E-10
  0.51359191342712271588E-10
  0.62730747867977636297E-10
  0.76618892012631225296E-10
  0.93583301711963271940E-10
  0.11430192677538819367E-09
  0.13960991678261530046E-09
  0.17051839200598010096E-09
  0.20827357888452780935E-09
  0.25438347678424908063E-09
  0.31070775906120548243E-09
  0.37949543960166480335E-09
  0.46352165150554629058E-09
  0.56614048928061041213E-09
  0.69149327357632214648E-09
  0.84458207882202713872E-09
  0.10315871013042910049E-08
  0.12599679520777700732E-08
  0.15389476810193000824E-08
  0.18796505921747109347E-08
  0.22958410530823679168E-08
  0.28041080392694730677E-08
  0.34249937978079458891E-08
  0.41832358233125644067E-08
  0.51094925678131643906E-08
  0.62406516508546298375E-08
  0.76224707236306606749E-08
  0.93099537030146089046E-08
  0.11371395622837669325E-07
  0.13888811603603460790E-07
  0.16964137540446880094E-07
  0.20719660567011048447E-07
  0.25307532985450009557E-07
  0.30910082760196839954E-07
  0.37754423983369756739E-07
  0.46112394911463966981E-07
  0.56323015017988116740E-07
  0.68791561040010018689E-07
  0.84024115221375004322E-07
  0.10262487036321569423E-06
  0.12534932630323100331E-06
  0.15309818493173440690E-06
  0.18699933285775400780E-06
  0.22839543319719978897E-06
  0.27897038209650021238E-06
  0.34072557173474452451E-06
  0.41617511631609012044E-06
  0.50830216571405257032E-06
  0.62086055851273829343E-06
  0.75829654716288451693E-06
  0.92621529324795927674E-06
  0.11312433484295780322E-05
  0.13817506779893170808E-05
  0.16876126549713120575E-05
  0.20613285048301949073E-05
  0.25176142217059249495E-05
  0.30751364937151691114E-05
  0.37558230263550338492E-05
  0.45875527884742903516E-05
  0.56029966733669012944E-05
  0.68437947583602416914E-05
  0.83586201447068474255E-05
  0.10209670082926559548E-04
  0.12469450254224749995E-04
  0.15230868871022190138E-04
  0.18601920832727638478E-04
  0.22721395800711319485E-04
  0.27750126132155010419E-04
  0.33895447798826631189E-04
  0.41396841136470921454E-04
  0.50564046316342118052E-04
  0.61753575721436104002E-04
  0.75428141719150856360E-04
  0.92118338007583430976E-04
  0.11251534681498950364E-03
  0.13740856459760000547E-03
  0.16783029354650548710E-03
  0.20495440270807768974E-03
  0.25032223970649432505E-03
  0.30567824291028637771E-03
  0.37332275750272562662E-03
  0.45584569317397240131E-03
  0.55667758728412204596E-03
  0.67965842762967730497E-03
  0.82989825334180589590E-03
  0.10130793883812590737E-02
  0.12367998790718090669E-02
  0.15094441288791659965E-02
  0.18422782918639890679E-02
  0.22476208557991408411E-02
  0.27421062075955880862E-02
  0.33437164053099180556E-02
  0.40768527847886001578E-02
  0.49675073471938113734E-02
  0.60511176276551595712E-02
  0.73646815739407444149E-02
  0.89588637538056889453E-02
  0.10885052122857430054E-01
  0.13213887638701850638E-01
  0.16013879136554731025E-01
  0.19379495481742049084E-01
  0.23395566125555520426E-01
  0.28179341735834879251E-01
  0.33820790606197338735E-01
  0.40444641201110451134E-01
  0.48109746447546619663E-01
  0.56899341828119280595E-01
  0.66751684235759015107E-01
  0.77591144073115236868E-01
  0.89047612974465659152E-01
  0.10065405918556659393E+00
  0.11140105420732690500E+00
  0.12006932932879070541E+00
  0.12458597468885210247E+00
  0.12268765549548429905E+00
  0.11115942050671910601E+00
  0.87319954786645864742E-01
  0.48465000302246638575E-01
 -0.49561566373757083917E-02
 -0.69471081820978636268E-01
 -0.13351269533458298699E+00
 -0.17957507285653320772E+00
 -0.18191106295048839470E+00
 -0.12098476462017759836E+00
  0.57914272269164483384E-02
  0.15348128813633118983E+00
  0.23522097310698558692E+00
  0.15150400266403860061E+00
 -0.82790857821451305232E-01
 -0.27115431040159521103E+00
 -0.13312798063762890100E+00
  0.22420582796659790925E+00
  0.23042922487820899358E+00
 -0.25728138031301517330E+00
 -0.14755494381924760816E+00
  0.36119355267312441837E+00
 -0.24353715522887228739E+00
  0.38114547256147109089E-01
  0.82736503214593373756E-01
 -0.10914677811197480428E+00
  0.89643285228612118454E-01
 -0.60977888159322063411E-01
  0.37801231818370660542E-01
 -0.22438621211053739329E-01
  0.13156278189915569798E-01
 -0.77896933116771488112E-02
  0.47370324617059750630E-02
 -0.29965293695965681403E-02
  0.19878544860469768082E-02
 -0.13869827135561199356E-02
  0.10157400415733200925E-02
 -0.77631830897451124893E-03
  0.61460402632747919080E-03
 -0.50020690522478944255E-03
  0.41570616801530989705E-03
 -0.35086447759715891749E-03
  0.29949364033671969747E-03
 -0.25773573414907620556E-03
  0.22310488448276601017E-03
 -0.19394286742651010405E-03
  0.16910356690987170454E-03
 -0.14776630535110279563E-03
  0.12932306435161670878E-03
 -0.11330886340153000630E-03
  0.99357870873694533213E-04
 -0.87175171695487733894E-04
  0.76518203465147482511E-04
 -0.67184226920608184730E-04
  0.59001625485470532949E-04
 -0.51823700437172301393E-04
  0.45524131447897800190E-04
 -0.39993558219308811687E-04
  0.35136924058234570150E-04
 -0.30871356264610351938E-04
  0.27124444492712818783E-04
 -0.23832821622649580026E-04
  0.20940974022723349952E-04
 -0.18400228343346008335E-04
  0.16167881311147351016E-04
 -0.14206450345841819494E-04
  0.12483025923096489624E-04
 -0.10968708114345040680E-04
  0.96381137476371433619E-05
 -0.84689451209231461783E-05
  0.74416131426310713740E-05
 -0.65389076895947963034E-05
  0.57457083047103120349E-05
 -0.50487298647161201493E-05
  0.44362992864155191501E-05
 -0.38981597741651851768E-05
  0.34252990553006400639E-05
 -0.30097983612462208859E-05
  0.26446996057275441348E-05
 -0.23238887351302340716E-05
  0.20419933647589090787E-05
 -0.17942928642745300170E-05
  0.15766392837610099303E-05
 -0.13853878318735780200E-05
  0.12173358208997559817E-05
 -0.10696690610117151049E-05
  0.93991475334313001620E-06
 -0.82590006822179900410E-06
  0.72571573986650604055E-06
 -0.63768409395308406728E-06
  0.56033096589579911757E-06
 -0.49236101932854606775E-06
  0.43263604794155821972E-06
 -0.38015590945392312373E-06
  0.33404177953802387996E-06
 -0.29352143989559692218E-06
  0.25791634724263857612E-06
 -0.22663026755387299218E-06
  0.19913929019334100136E-06
 -0.17498305605429440553E-06
  0.15375705002049011184E-06
 -0.13510582667935480436E-06
  0.11871705693399870160E-06
 -0.10431629758749350038E-06
  0.91662396276475694184E-07
 -0.80543453607028647290E-07
  0.70773274428481856046E-07
 -0.62188249446989189968E-07
  0.54644615505335029221E-07
 -0.48016048443646231508E-07
  0.42191547784261369808E-07
 -0.37073577780952398937E-07
  0.32576433988135847120E-07
 -0.28624808133909398953E-07
  0.25152527127147581427E-07
 -0.22101444936595110588E-07
  0.19420468820503340806E-07
 -0.17064703711658711163E-07
  0.14994700450203629605E-07
 -0.13175795208633650552E-07
  0.11577529007302610104E-07
 -0.10173137628831489796E-07
  0.89391034277419880612E-08
 -0.78547615254943383801E-08
  0.69019537690386798258E-08
 -0.60647246504485460851E-08
  0.53290541108617648523E-08
 -0.46826227654829832319E-08
  0.41146056122897838021E-08
 -0.36154907601472161940E-08
  0.31769201408808051073E-08
 -0.27915495445014601903E-08
  0.24529256362912200658E-08
 -0.21553778928767579448E-08
  0.18939236446342600392E-08
 -0.16641846353897590312E-08
  0.14623137046133780063E-08
 -0.12849303645740829450E-08
  0.11290641920775340868E-08
 -0.99210508606754888054E-09
  0.87175955886335064848E-09
 -0.76601232990455893213E-09
  0.67309257867770258852E-09
 -0.59144429108839117984E-09
  0.51970020258742657674E-09
 -0.45665890207353687588E-09
  0.40126471338250552359E-09
 -0.35259001730495680327E-09
  0.30981971788986289322E-09
 -0.27223759293244408980E-09
  0.23921430022514762304E-09
 -0.21019683877088560052E-09
  0.18469928839465210504E-09
 -0.16229467261876449390E-09
  0.14260780857078909327E-09
 -0.12530902424439949164E-09
  0.11010863790384879428E-09
 -0.96752107149079824750E-10
  0.85015766394465004630E-10
 -0.74703081400610626905E-10
  0.65641358155343214620E-10
 -0.57678850985617859679E-10
  0.50682221459754282741E-10
 -0.44534305525909120100E-10
  0.39132151504364007283E-10
 -0.34385296082594761887E-10
  0.30214249439239317785E-10
 -0.26549164124680559140E-10
  0.23328665408564599349E-10
 -0.20498823510896081544E-10
  0.18012250506600650469E-10
 -0.15827306778509629286E-10
  0.13907403728951850551E-10
 -0.12220391074163700618E-10
  0.10738018462452050425E-10
 -0.94354624003716234485E-11
  0.82909105640953193728E-11
 -0.72851965346947523766E-11
  0.64014788411436639934E-11
 -0.56249589367146987257E-11
  0.49426333858928202302E-11
 -0.43430761116809759680E-11
  0.38162470568545827330E-11
 -0.33533240552467311054E-11
  0.29465550976975220819E-11
 -0.25891285186428910646E-11
  0.22750589294212621855E-11
 -0.19990869881930792011E-11
  0.17565913281172699705E-11
 -0.15435111689614020217E-11
  0.13562783161689700960E-11
 -0.11917574086305238998E-11
  0.10471934145827610682E-11
 -0.92016549643814607864E-12
  0.80854647197038528016E-12
 -0.71046719298279401734E-12
  0.62428524494839663246E-12
 -0.54855744348363701401E-12
  0.48201566709453555482E-12
 -0.42354562149103289211E-12
  0.37216817985480538490E-12
 -0.32702298658923321260E-12
  0.28735404998800310208E-12
 -0.25249708256169828971E-12
  0.22186837702370389530E-12
 -0.19495503165314128815E-12
  0.17130636135177430412E-12
 -0.15052635056794931119E-12
  0.13226702170589389284E-12
 -0.11622260796808300942E-12
  0.10212443304988860003E-12
 -0.89736411943535084833E-13
  0.78851097509314687508E-13
 -0.69286206610625636538E-13
  0.60881567639821682927E-13
 -0.53496438318744010298E-13
  0.47007148858659282416E-13
 -0.41305031012602458038E-13
  0.36294598340360191951E-13
 -0.31891947213064369610E-13
  0.28023351780988580919E-13
 -0.24624029376283279094E-13
  0.21637055676372050574E-13
 -0.19012411461508211104E-13
  0.16706145003659701281E-13
 -0.14679636060291389006E-13
  0.12898949148078830678E-13
 -0.11334265266611379683E-13
  0.99593825558268706535E-14
 -0.87512775252863140427E-14
  0.76897195077421143642E-14
 -0.67569318807328292835E-14
  0.59372943830891981248E-14
 -0.52170815413984568005E-14
  0.45842328261723863703E-14
 -0.40281506888097158469E-14
  0.35395230973258291850E-14
 -0.31101675990681859105E-14
  0.27328942991223000800E-14
 -0.24013854598749791415E-14
  0.21100897055373030150E-14
 -0.18541290599993040151E-14
  0.16292172612908320081E-14
 -0.14315879847593459752E-14
  0.12579317730060459754E-14
 -0.11053406164233719234E-14
  0.97125925629132513426E-15
 -0.85344239496416429968E-15
  0.74991709659831521783E-15
 -0.65894974879250159170E-15
  0.57901703188703568188E-15
 -0.50878040978025863482E-15
  0.44706371509062259811E-15
 -0.39283345331036878858E-15
  0.34518149612852799007E-15
 -0.30330987410939582363E-15
  0.26651741406787180955E-15
 -0.23418799737396022297E-15
  0.20578024256254929268E-15
 -0.18081843947571900690E-15
  0.15888458312267581200E-15
 -0.13961137385800899984E-15
  0.12267606666074510376E-15
 -0.10779506651556279801E-15
  0.94719179391603797610E-16
 -0.83229439292786975771E-16
  0.73133441500293154255E-16
 -0.64262120604484965377E-16
  0.56466919371882109638E-16
 -0.49617301037651720597E-16
  0.43598563364994760812E-16
 -0.38309917866133909996E-16
  0.33662802019951652661E-16
 -0.29579396223041629810E-16
  0.25991320639354369445E-16
 -0.22838490126158601174E-16
  0.20068108061152711033E-16
 -0.17633782221571330287E-16
  0.15494747909989438574E-16
 -0.13615185317456429361E-16
  0.11963619692670830272E-16
 -0.10512394272558709913E-16
  0.92372071480646483496E-17
 -0.81167043096073984687E-17
  0.71321220574247113037E-17
 -0.62669727886873747397E-17
  0.55067688996430172615E-17
 -0.48387801793162163364E-17
  0.42518206321314128635E-17
 -0.37360611596341719162E-17
  0.32828649645187700314E-17
 -0.28846429206752079096E-17
  0.25347264873153391346E-17
 -0.22272560390247178611E-17
  0.19570827417369101585E-17
 -0.17196823314652230881E-17
  0.15110793519499210062E-17
 -0.13277805825221979748E-17
  0.11667165413822330724E-17
 -0.10251900847168659743E-17
  0.90083124090830315999E-18
 -0.79155752349720990603E-18
  0.69553905830937584557E-18
 -0.61116794077226843712E-18
  0.53703131028706945667E-18
 -0.47188769076765341320E-18
  0.41464620115119749872E-18
 -0.36434828774274431505E-18
  0.32015167248500091253E-18
 -0.28131624835279290921E-18
  0.24719168567911820595E-18
 -0.21720654187174320654E-18
  0.19085869215550189721E-18
 -0.16770692109721899111E-18
  0.14736353410746910352E-18
 -0.12948786519216900428E-18
  0.11378057223455149305E-18
 -0.99978624276428549682E-19
  0.87850896856935804010E-19
 -0.77194301650481244444E-19
  0.67830385593241861930E-19
 -0.59602342548611573044E-19
  0.52372387468676202365E-19
 -0.46019449077998791288E-19
  0.40437142440414807125E-19
 -0.35531987457892000724E-19
  0.31221843469976618630E-19
 -0.27434533741424270108E-19
  0.24106636804928459342E-19
 -0.21182424419102399996E-19
  0.18612928356413968765E-19
 -0.16355120393022199627E-19
  0.14371191768318589670E-19
 -0.12627920047644379558E-19
  0.11096112785317059883E-19
 -0.97501186719036165739E-20
  0.85673979808058807363E-20
 -0.75281451224231245595E-20
  0.66149569855872109159E-20
 -0.58125415113657893624E-20
  0.51074616176521397340E-20
 -0.44879101854824920831E-20
  0.39435123390814399527E-20
 -0.34651517093082292638E-20
  0.30448177717368800233E-20
 -0.26754717030230440586E-20
  0.23509285093699011334E-20
 -0.20657534540814548706E-20
  0.18151710504142631532E-20
 -0.15949850948474660527E-20
  0.14015083996708770500E-20
 -0.12315010469494319376E-20
  0.10821161305372590522E-20
 -0.95085207960662486644E-21
  0.83551076750596628203E-21
 -0.73416070535124345550E-21
  0.64510470249568779156E-21
 -0.56685144894552668532E-21
  0.49809054123125183129E-21
 -0.43767053435643358195E-21
  0.38457965596782228367E-21
 -0.33792886257541818238E-21
  0.29693695347390241880E-21
 -0.26091749061412948769E-21
  0.22926730418560010001E-21
 -0.20145639198759520765E-21
  0.17701904387406560389E-21
 -0.15554604225258168932E-21
  0.13667780796729550641E-21
 -0.12009837779858251158E-21
  0.10553011379060780116E-21
 -0.92729055585803990884E-22
  0.81480836646395174933E-22
 -0.71597094891875700200E-22
  0.62912317547278588468E-22
 -0.55281068025898321612E-22
  0.48575549320856098216E-22
 -0.42683463880645999618E-22
  0.37506134255287311446E-22
 -0.32956852260392350507E-22
  0.28959427878761049247E-22
 -0.25446913153691919200E-22
  0.22360480394754259887E-22
 -0.19648436888446069881E-22
  0.17265359799157371192E-22
 -0.15171336029025659557E-22
  0.13331293566397819119E-22
 -0.11714413365284629986E-22
  0.10293612991331600087E-22
 -0.90450942661818855010E-23
  0.79479472072663889120E-23
 -0.69838025973983943288E-23
  0.61365260759698707238E-23
 -0.53919477932897098293E-23
  0.47376234574340661915E-23
 -0.41626240529454467843E-23
  0.36573513415638608941E-23
 -0.32133750545472298724E-23
  0.28232876298439711191E-23
 -0.24805746766402519629E-23
  0.21795021088492381699E-23
 -0.19150207966391389939E-23
  0.16826867531148651179E-23
 -0.14785926095987099109E-23
  0.12993065708576839773E-23
 -0.11418169017687040810E-23
  0.10034812450227850599E-23
 -0.88198046609572075136E-24
  0.77527684778131062791E-24
 -0.68157678580025223715E-24
  0.59929859006652480651E-24
 -0.52704590637343920302E-24
  0.46358624111797927966E-24
 -0.40783289235105509668E-24
  0.35882870194420578191E-24
 -0.31573129057568951175E-24
  0.27780031811537501369E-24
 -0.24438721059930989498E-24
  0.21492709123302868776E-24
 -0.18893185489531158875E-24
  0.16598283447655300523E-24
 -0.14572197983278360944E-24
  0.12784189795680629463E-24
 -0.11207611655384429414E-24
  0.98190635833986939235E-25
 -0.85977069575473510383E-25
  0.75247618025397713641E-25
 -0.65832296928724367365E-25
  0.57578153084183532562E-25
 -0.50349088175171190647E-25
  0.44024756065989681357E-25
 -0.38498191971011007846E-25
  0.33673291115583042791E-25
 -0.29463411791224339510E-25
  0.25791217847239958719E-25
 -0.22588731181811621204E-25
  0.19796670767579898895E-25
 -0.17363295672276158774E-25
  0.15243569288426309447E-25
 -0.13398787953334260281E-25
  0.11796045820480120133E-25
 -0.10407147490908270710E-25
  0.92071944889040744035E-26
 -0.81731249295591442672E-26
  0.72825159703487444195E-26
 -0.65131006447129183541E-26
  0.58430301262485386924E-26
 -0.52513930081011199285E-26
  0.47187919679302219783E-26
 -0.42284069142292412393E-26
  0.37676954747502728537E-26
 -0.33299134001135826479E-26
  0.29143004338630110718E-26
 -0.25243668234065648260E-26
  0.21646903157623978348E-26
 -0.18376734028052161580E-26
  0.15423017366879009263E-26
 -0.12758944190588119779E-26
  0.10371662830395429178E-26
 -0.82748173500706471962E-27
  0.64909427840638429032E-27
 -0.50234666376562531025E-27
  0.38452110973130778698E-27
 -0.29091636205058451455E-27
  0.21678009467166822096E-27
 -0.15874578619111640200E-27
  0.11537394235020309101E-27
 -0.86900364189788941857E-28
  0.74355723662636970071E-28
 -0.78471428315427385396E-28
  0.98949852128730596091E-28
 -0.13427202805922251023E-27
  0.18174242734021449278E-27
 -0.23763619609508699858E-27
  0.29778198107110528091E-27
 -0.35868369680655068529E-27
  0.41844766665021181973E-27
 -0.47660851066880372752E-27
  0.53287774452581460041E-27
 -0.58588249858342115784E-27
  0.63294098597067369917E-27
 -0.67092689718604759703E-27
  0.69754161721794173542E-27
 -0.71229292612293631973E-27
  0.71678213553979546309E-27
 -0.71422093211775989035E-27
  0.70847857438160299782E-27
 -0.70324864718393631473E-27
  0.70176504791510964044E-27
 -0.70696084721646144402E-27
  0.72149205056137611593E-27
];
Y=YBASE/B;
YF=feval(funname,Y);
z1=WT1.'*YF;
%
%  Finally correct for the factor of 1/B.
%
z1=z1/B;
