%
%  rdb=reflect(epsilonrm,epsilonim,epsilonrs,epsilonis)
%
%    epsilonrm           Real part of epsilon for the mine.
%    epsilonim           imag part of epsilon for the mine.
%    epsilonrs           Real part of epsilon for the medium.
%    epsilonis           imag part of epsilon for the medium.
%
% Computes the reflection loss in db given the dielectric constants of
% the mine and and the medium surrounding the mine.  This reflection is
% based on the assumption of normal incidence of a plane wave.  
%
function rdb=reflect(epsilonrm,epsilonim,epsilonrs,epsilonis)
km=epsilonrm+epsilonim*sqrt(-1);
ks=epsilonrs+epsilonis*sqrt(-1);
r=(sqrt(ks)-sqrt(km))/(sqrt(ks)+sqrt(km));
rdb=10*log10(1/(abs(r)^2));
