%
%    Generates a plot of Loss vs. Soil Water Contents
%    
%   DEFINITIONS
%    epsilonrm           Real part of epsilon for the mine.
%    epsilonim           imag part of epsilon for the mine.
%    epsilonrs           Real part of epsilon for the medium.
%    epsilonis           imag part of epsilon for the medium.
%    
function dbs=plotloss()
%
% Basic information about 
%
%   depth                              Depth to mine in meters.
%   SandFraction, ClayFraction         Soil Texture information.
%   BulkDensity                        Bulk Density of the coil, g/cm^3
%   frequency                          Radar freq in Hz, 300Mhz to 1.3Ghz.
%   epsilonrm,epsilonim                Mine dielectric constant real/imag. 
%  
depth=0.15;              % Mine at 15 cm.
SandFraction=0.95;       % Measured in the lab.
ClayFraction=0.02;       % Measured in the lab.
BulkDensity=1.6;         % Measured in the lab.
rhos=2.66;
frequency=900e6;       % Our GPR operates at 900 Mhz.
epsilonrm=3.2;         % Need a more realistic value here.
epsilonim=0;           %
%
%  Now loop through water contents from 0.001 to 0.5.
%
theta=0.001;
for n=1:500
   [epsilonrs,epsilonis]=myeps(theta,frequency,SandFraction,ClayFraction,BulkDensity,rhos);
   [y1(n),y2(n),y3(n)]=loss(frequency,depth,epsilonrm,epsilonim,epsilonrs,epsilonis);
   x(n)=theta;
   theta=theta+0.001;
end
%
% Now, plot the results.
%
[x',y1',y2',y3'];
plot(x,y1,'k--',x,y2,'k:',x,y3,'k-');
hold on
xlabel('Water Content');
ylabel('Loss in db');
title('Losses as a Function of Water Content');
legend('Attenuation','Reflection','Total');
%
% Return the total losses.
%
dbs=y3;



