%
%  [er,ei]=myeps(theta,f,sand,clay,rhob,rhos)
%  
%  Computes the er and ei given sand and clay fraction and frequency
%  er and ei are the real and imaginary part of complex dielectrics, resp.
%
%    theta              Volumetric water content 
%    f                  frequency (Hz)
%    sand               sand fraction (e.g. 0.50, not 50 for 50%)
%    clay               clay fraction
%    rhob               Bulk soil density (typically about 1.6)
%    rhos               Density of soil particles (typically about 2.6)
%
% Uses either the Dobson et al. 1985 or Peplinski et al. 1995 models to
% predict dielectric constant for a soil.   
%  
function [er,ei]=myeps(theta,f,sand,clay,rhob,rhos)
%
% 0.3-1.3 Ghz.
%
if (f >= 3e8) & (f <= 1.4e9),
  [er,ei]=loweps(theta,f,sand,clay,rhob,rhos);
  return;
end;
%
% 1.4 Ghz and up.
%
if (f>1.4e9),
  [er,ei]=higheps(theta,f,sand,clay,rhob,rhos);  
  return;
end;
%
% Outside of these frequency ranges, neither model is valid.
%
er=NaN;
ei=NaN;
