%
% This script plots epsr and epsi for the Sevilleta sand soil. 
%
% Basic information about 
%
%   depth                              Depth to mine in meters.
%   SandFraction, ClayFraction         Soil Texture information.
%   rhob                               Bulk Density of the coil, g/cm^3
%   rhos                               Density of soil particles.  
%   frequency                          Radar freq in Hz, 300 Mhz to 6.0 Ghz.
%   epsilonrm,epsilonim                Mine dielectric constant real/imag. 
%  
SandFraction=0.95;       % Measured in the lab.
ClayFraction=0.02;       % Measured in the lab.
rhob=1.6;                % Measured in the lab.
rhos=2.66;               % A standard value.
%
% First, very Frequency.  
%
figure(1);
%
%
%
frequency=900e6;
%
% Loop through water contents from 0 to 0.5
%
thetas=0.001:0.01:0.5;
epsr=[];
epsi=[];
for theta=thetas,
   [epsilonrs,epsilonis]=myeps(theta,frequency,SandFraction,ClayFraction,rhob,rhos);
   epsr=[epsr epsilonrs];
   epsi=[epsi epsilonis];  
end;
%
%
%
plot(thetas,epsr,'k',thetas,epsi,'k--');
xlabel('Water Content (%)');
ylabel('Dielectric Constant');
legend('Real','Imaginary',2);
title('Frequency 900 Mhz');




