%
%  [er,ei]=loweps(theta,f,sand,clay,rhob,rhos)
%  
%  Computes the er and ei given sand and clay fraction and frequency
%  er and ei are the real and imaginary part of complex dielectrics, resp.
%
%    theta              Volumetric water content 
%    f                  frequency (Hz)
%    sand               sand fraction (e.g. 0.50, not 50 for 50%)
%    clay               clay fraction
%    rhob               Bulk soil density (typically about 1.6)
%    rhos               Density of soil particles (typically about 2.6)
%
%
%  Uses Eq. 9 of Peplinski et al. 1995 to estimate real of dielctrics for 
%  the 0.3-1.3GHz band.
%
%  Uses Eq. 10 of Peplinski et al. 1995 to estimate imaginary part.
%  
function [er,ei]=loweps(theta,f,sand,clay,rhob,rhos)
TwoPitauw=0.58e-10;
ew0=80.1;
e0=8.85e-12;
ewinf=4.9;
a=0.65;
%
beta1=1.2748-0.519*sand-0.152*clay;
beta2=1.33797-0.603*sand-0.166*clay;
sigeff=0.0467+0.2204*rhob-0.4111*sand+0.6614*clay;
efw1=ewinf+(ew0-ewinf)/(1+(TwoPitauw*f)^2);
efw2=TwoPitauw*f*(ew0-ewinf)/(1+(TwoPitauw*f)^2)+sigeff*(rhos-rhob)/(2*pi*e0*f*rhos*theta);
es=((1.01+0.44*rhos)^2)-0.062;
er=(1+rhob*(es^a-1)/rhos+(theta^beta1)*(efw1^a)-theta)^(1/a);
er=1.15*er-0.68;
ei=((theta^beta2)*(efw2^a))^(1/a);


