%
%   [ldb1,ldb2,ldb]=loss(theta,freq,depth,epsilonrm,epsilonim,epsilonrs,epsilonis)
%   ldb1 is the attenuation component and ldb2 is the reflection component 
%   of the total loss ldb
%
%   epsilonrm           Real part of epsilon for the mine.
%   epsilonim           imag part of epsilon for the mine.
%   epsilonrs           Real part of epsilon for the medium.
%   epsilonis           imag part of epsilon for the medium.
%   depth               depth to mine in meters
%   freq                frequency in Hz
%
function [ldb1,ldb2,ldb]=loss(freq,depth,epsilonrm,epsilonim,epsilonrs,epsilonis)
ldb1=-2*depth*8.6859*alpha(epsilonrs,epsilonis,freq);
ldb2=-reflect(epsilonrm,epsilonim,epsilonrs,epsilonis);
ldb=(ldb1+ldb2);







